package nl.oostnl.ventureplan.jobs.clockwise;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.postgresql.util.PGobject;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.Properties;
import nl.ppmoost.ventureplan2.ClockWiseException;
import nl.ppmoost.ventureplan2.ClockWiseREST;


public class ImportFromClockwise implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(ImportFromClockwise.class);
	
	private Properties iProperties;
	private Map<String,Object> iParams;
	
	private XamEngine iXE=null;
	private Dataset iDataset;
	private Dataset iUren;
	
	public ImportFromClockwise() {
		super();
		iXE=new XamEngine();
		try {
			iUren=iXE.getDataset("Uren");
		} catch (DatasetException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public Operator getOperator(String pName) {
		/* nothin for now*/
		return null;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);

	}

	@Override
	public void setParameter(String pName, List<Object> pValue) {
		/* nothin for now*/
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean supportsResultset() {
		return false;
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		/* no support */
		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		/* no support */
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		/*Haal json op vanuit clockwise*/
		//Haal access token
		String lClientId=iProperties.getProperty("ClientId");
		String lUsername=iProperties.getProperty("Username");
		String lPassword=iProperties.getProperty("Password");
		String lUrenEndpoint=iProperties.getProperty("lUrenEndpoint");
		String lContentStr = null;
		
		try {
			ClockWiseREST lCWRest=new ClockWiseREST();
			lCWRest.getAccessToken(lClientId, lUsername, lPassword);
			
			lContentStr = lCWRest.doGetString(lUrenEndpoint);
		} catch (ClockWiseException e) {
			throw new OperationException(e);
		}
		
		//Importeer uren in tijdelijke tabel
		Operation lOperTruncate = iUren.getOperation("TruncateTemp");
		lOperTruncate.executeAsValueMap();
		lOperTruncate.close();
		
		Operation lOperImport = iUren.getOperation("Import");
		
		try {
			PGobject lJsonObject = new PGobject();
			lJsonObject.setType("json");
			lJsonObject.setValue(lContentStr);
			
			lOperImport.setParameter("content", lJsonObject);
			lOperImport.executeAsValueMap();
			
		} catch (SQLException e) {
			throw new OperationException(e);
		}
		
		//Verwerk uren in echte tabel
		Operation lOperProcess=iUren.getOperation("Process");
		return lOperProcess.executeAsValueList();
	}

	@Override
	public void close() {
		/* nothin for now*/

	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;

	}

	@Override
	public void setDataset(Dataset pDataset) {
		iDataset = pDataset;

	}

	@Override
	public String getDescription() {
		return "Import uren samenvatting van Clockwise in Ventureplan";
	}

}
