/**
 * 
 */
package nl.oostnl.ventureplan.jobs.dynamics;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

import com.fasterxml.jackson.databind.ObjectMapper;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Properties;
import nl.ppmoost.ventureplan2.vp_change;


/**
 * @author stpl
 *
 */
public class SyncProjects implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.3 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(SyncProjects.class);
	
	private Properties iProperties;
	private Map<String,Object> iParams;
	
	private XamEngine iXE=null;
	private Dataset iDataset;
	private Dataset iProjectDataset;
	private CloseableHttpClient iClient=null;
	
	/**
	 * 
	 */
	public SyncProjects() {
		super();
		iClient=HttpClients.createDefault();
		iXE=new XamEngine();
		try {
			iProjectDataset=iXE.getDataset("Project");
		} catch (DatasetException e) {
			throw new RuntimeException(e);
		}
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#getOperator(java.lang.String)
	 */
	@Override
	public Operator getOperator(String pName) {
		/* nothin for now*/
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#setParameter(java.lang.String, java.lang.Object)
	 */
	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);

	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#setParameter(java.lang.String, java.util.List)
	 */
	@Override
	public void setParameter(String pName, List<Object> pValue) {
		/* nothin for now*/

	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#canExecute()
	 */
	@Override
	public boolean canExecute() {
		return true;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#supportsResultset()
	 */
	@Override
	public boolean supportsResultset() {
		return false;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#executeAsResultset()
	 */
	@Override
	public ResultSet executeAsResultset() throws OperationException {
		/* no support */
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#executeAsValueMap()
	 */
	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		/* no support */
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#executeAsValueList()
	 */
	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		List<vp_change> lChanges=null;
		Operation projData=iProjectDataset.getOperation("DynamicsData");
		ObjectMapper mapper=new ObjectMapper();
		String token=null;
		
		String clientId=ConfigurationProperties.get().get("DYNAMICS.client_id");
		String clientSecret=ConfigurationProperties.get().get("DYNAMICS.client_secret");
		String resource=ConfigurationProperties.get().get("DYNAMICS.resource");
		String authority=ConfigurationProperties.get().get("DYNAMICS.authority");
		if (log4j.isDebugEnabled()){
			log4j.debug("DYNAMCS.client_id=" + clientId);
			log4j.debug("DYNAMCS.client_secret=" + clientSecret);
			log4j.debug("DYNAMCS.resource=" + resource);
			log4j.debug("DYNAMCS.authority=" + authority);
		}
		
		
		//vullen obv config
		String dynamicsUrlBase=resource + "/api/data/v9.0/opportunities";
		
		//Get the changed projects
		lChanges=vp_change.getChanges("vp_project","dynamics");
		
		//loop over changes
		for (vp_change lChange : lChanges){
			log4j.info("Processing change: " + lChange.toString());
			
			//Get token if not token is null
			if (token==null){
				log4j.info("First change, get token from " + authority);
				AzureLogin azureLogin=new AzureLogin(clientId, clientSecret, resource, authority);
				token=azureLogin.getToken();
			}
		
			//Get changed data
			projData.setParameter("proj_id", lChange.getItemId());
			List<Map<String,Object>> lResults=projData.executeAsValueList();
			
			if (lResults.isEmpty()){
				log4j.warn("Change id: " + lChange.getId() + " has no project data!!!");
				lChange.markAsError(8, "No project data");
				continue;
			}
			
			StringWriter lBodyJson=new StringWriter();
			String dynamicsUrl=dynamicsUrlBase + "(" + lResults.get(0).get("dynamics_id") + ")";
			
			//remove dynamics from result
			lResults.get(0).remove("dynamics_id");
			
			try {
				mapper.writeValue(lBodyJson, lResults.get(0) );
			} catch (IOException e) {
				log4j.warn("Change id: " + lChange.getId() + " has errors when creating body",e);
				lChange.markAsError(8, "Error creating body!");
				continue;
			}
			
			if (log4j.isDebugEnabled()){
				log4j.debug("JSON body: " + lBodyJson.toString());
			}
			
			//Create call
			log4j.info("Sending change " + lChange.toString() + " data to " + resource);
			CloseableHttpResponse lGetResponse;
			HttpPatch patch=new HttpPatch(dynamicsUrl);
			
			patch.addHeader("Authorization", "Bearer " + token);	
			patch.addHeader("Content-Type","application/json; charset=utf-8");
			patch.addHeader("Accept","application/json");
			patch.addHeader("OData-MaxVersion","4.0");
			patch.addHeader("OData-Version","4.0");
			
			
			try {
				StringEntity body=new StringEntity(lBodyJson.toString(),"UTF-8");
				
				patch.setEntity(body);
				
				//send update to dynamics
				log4j.info("Send to url: " + dynamicsUrl);
				log4j.debug("-- body: " + patch.toString());
				lGetResponse = iClient.execute(patch);
				
				if (lGetResponse.getStatusLine().getStatusCode()!=204){
					log4j.warn("Change id: " + lChange.getId() + " has errors when sending body, httpstatus: " + lGetResponse.getStatusLine().getStatusCode());
					String lerror=null;
					IOUtils.toString(lGetResponse.getEntity().getContent(),lerror);
					log4j.warn("--returnb body: " + lerror);
					lChange.markAsError(8, "Error sending body, httpstatus: " + lGetResponse.getStatusLine().getStatusCode());
				}
			} catch (IOException e) {
				log4j.warn("Change id: " + lChange.getId() + " has errors when sending body",e);
				lChange.markAsError(8, "Error creating body!");
				continue;
			}
			
			//mark as succesful
			lChange.markAsSuccess();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#close()
	 */
	@Override
	public void close() {
		/* nothin for now*/

	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#setProperties(nl.knowledgeplaza.util.Properties)
	 */
	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;

	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#setDataset(nl.buildersenperformers.xam.engine.Dataset)
	 */
	@Override
	public void setDataset(Dataset pDataset) {
		iDataset = pDataset;

	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#getDescription()
	 */
	@Override
	public String getDescription() {
		return "Synchronizes project data to Dynamics";
	}

}
