package nl.oostnl.ventureplan.jobs.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.innovationinvestments.docstore.storage.FileContainer;
import nl.innovationinvestments.docstore.storage.FilesContainer;
import nl.innovationinvestments.docstore.storage.Storage;
import nl.innovationinvestments.docstore.storage.StorageFilesystem;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Properties;
import nl.knowledgeplaza.util.StringUtil;

public class ListDiffDocstore implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.3 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(ListDiffDocstore.class);
	private Properties iProperties;
	private Map<String,Object> iParams;
	private List<String> iPathCache;
	
	private XamEngine iXE=null;
	private Dataset iDsDocuments=null;
	private Dataset iDataset;
	private String iDocstoreBase=null;
	
	public ListDiffDocstore() {
		super();
		iXE = new XamEngine();
		try {
			iDsDocuments = iXE.getDataset("Documents");
		} catch (DatasetException e) {
			throw new RuntimeException(e);
		}
		
		iParams=new HashMap<>();
		iPathCache=new ArrayList<>();
	}

	@Override
	public Operator getOperator(String pName) {
		/* nothin for now*/
		return null;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);
	}

	@Override
	public void setParameter(String pName, List<Object> pValue) {
		/* nothin for now*/
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean supportsResultset() {
		return false;
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		/* no support */
		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		/* no support */
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		List<Map<String, Object>> lRetVal=new ArrayList<>();
		
		String lProc="Diff van documents";
		PROCESS_LOGGER.start(lProc);
		
		Operation lListDocs=null;
		
		if (iParams.containsKey("org_id")){
			lListDocs=iDsDocuments.getOperation("ListGenDocumentsByOrg");
			lListDocs.setParameter("org_id", (String)iParams.get("org_id"));
			
		} else if (iParams.containsKey("doc_id")) {
			lListDocs=iDsDocuments.getOperation("ListGenDocuments");
			lListDocs.setParameter("doc_id", new Integer((String)iParams.get("doc_id")));
			
		} else {
			throw new OperationException("no org_id or doc_id parameter set");
		}
		
		ResultSet lResDocs=lListDocs.executeAsResultset();
		
		String lBase=(String) iParams.get("base");
		String lDocstoreConfigpPath = (String) iParams.get("docstoreConfig");
		FileWriter lWriter=null;
		BufferedWriter lBWriter=null;
		try {
			lWriter=new FileWriter((String) iParams.get("resultFile"));
			lBWriter=new BufferedWriter(lWriter);
		} catch (IOException e1) {
			throw new OperationException(e1);
		}
		
		Storage lStorage=getStorage(lDocstoreConfigpPath,lBase);
		
		
		try {
			while (lResDocs.next()){
				// create FilesContainer
				FilesContainer lFilesContainer = createFilesContainer(lResDocs.getString("name"), null);
				
				FilesContainer lFilesContainerResult = null;
				
				try
				{
					// hand it over and show result
					if (log4j.isDebugEnabled()) log4j.debug("Handing over to storage.select");
					lFilesContainerResult = lStorage.select(lFilesContainer);
					if (log4j.isDebugEnabled()) log4j.debug("Back from storage...");
					
					if (lFilesContainerResult.files.size() == 1 && lFilesContainerResult.files.get(0).inputStream != null){
						if (lFilesContainerResult.files.get(0).inputStream instanceof FileInputStream){
							String file=lFilesContainerResult.files.get(0).localPathName;
							
							
							String relFile=relativePath(iDocstoreBase, file);
							String relPath="";
							for (String lpart : relFile.split("\\/")){
								relPath += lpart;
								
								if (!iPathCache.contains(relPath)){
									iPathCache.add(relPath);
									File lFile=new File(iDocstoreBase + "/" + relPath);
									if (!lFile.isDirectory()){
										lBWriter.write (relPath);
										lBWriter.newLine();
									}
									String propFile=relPath + ".properties";
									lBWriter.write (propFile);
									lBWriter.newLine();
								}
								relPath += "/";
								
							}
							
							
						}
						
					}
				}
				catch (Throwable t) 
				{
					if (iParams.containsKey("logFileErrors")){
						log4j.warn("Error getting file",t);
						
					}
					continue;
				}
				
				
			}
			lBWriter.close();
			lWriter.close();
		} catch (SQLException | IOException e) {
			throw new OperationException(e);
		}
		
		PROCESS_LOGGER.complete(lProc);
		
		return lRetVal;
	}

	private Storage getStorage(String pDocstoreConfigpPath,String pBase) {
		File[] lConfigFiles={new File(pDocstoreConfigpPath)};
		ConfigurationProperties lConfig = new ConfigurationProperties(lConfigFiles);
		ConfigurationProperties.set(lConfig);
		
		// the result
		Storage lStorage = null;
		
		// get the id of the storage to use
		String lStorageId = pBase;
		if (log4j.isDebugEnabled()) log4j.debug("storage '"  + lStorageId + "'");
		if (StringUtil.isEmpty(lStorageId)) throw new IllegalArgumentException("Could not determine the storage to use");
		
		// nope, create the storage
		String lStorageType = lConfig.get2(this, lStorageId + ".type");
		iDocstoreBase = lConfig.get2(this, lStorageId + ".basedir");
		if (log4j.isDebugEnabled()) log4j.debug("storage '"  + lStorageId + "' type=" + lStorageType);
		if ("FileSystem".equals(lStorageType))
		{
			lStorage = new StorageFilesystem(lStorageId);
		}
		else throw new IllegalStateException("Unknown storagetype: "  + lStorageType);
		
		return lStorage;
	}

	@Override
	public void close() {
		/* nothin for now*/

	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;

	}

	@Override
	public void setDataset(Dataset pDataset) {
		iDataset = pDataset;

	}

	@Override
	public String getDescription() {
		return "List of files from docstore since doc_id";
	}

	/**
	 * 
	 * @param fileItems
	 * @return
	 */
	private FilesContainer createFilesContainer(String pName, List<FileItem> fileItems)
	throws IOException
	{
		// get the part of the URL that denotes the file
		String lFilePath = pName;
		// if it ends with a / then it is a directory only, else it also contains a filename
		String lDirName = null; 
		String lFileName = null;
		if (lFilePath.endsWith("/"))
		{
			lDirName = lFilePath;
		}
		else
		{
			lDirName = extractDirName( lFilePath );
			lFileName = extractFileName( lFilePath );
		}
		
		// result
		FilesContainer lFilesContainer = new FilesContainer();
		lFilesContainer.dirName = lDirName; // set the directory
		
		// Process the uploaded files
		if (fileItems != null)
		{
			for (FileItem lFileItem : fileItems)
			{
				if (lFileItem.isFormField())
				{
					lFilesContainer.properties.put(lFileItem.getFieldName(), lFileItem.getString());
				}
				else
				{
					FileContainer lFileContainer = new FileContainer();
					lFileContainer.inputStream = lFileItem.getInputStream();				
					lFileContainer.name = (lFileName != null ? lFileName : new File(lFileItem.getName()).getName() ); // lose the directory, only the file name is relevant
					lFileContainer.contentType = lFileItem.getContentType();
					lFileContainer.size = lFileItem.getSize();
					lFileContainer.fieldname = lFileItem.getFieldName();
					lFileContainer.localPathName = lFileItem.getName();
					
					lFilesContainer.files.add(lFileContainer);
				}
			}
		}
		// if there was a filename specified, but we have no uploads, create an empty file
		if (lFileName != null && lFilesContainer.files.size() == 0)
		{
			// filename
			FileContainer lFileContainer = new FileContainer();
			lFileContainer.name = lFileName; // the filepath is a directory + filename
			lFilesContainer.files.add(lFileContainer);
		}
		
		// done
		return lFilesContainer;
	}
	
	private String extractDirName(String filePath) { return filePath.substring(0, filePath.lastIndexOf("/") + 1); }
	private String extractFileName(String filePath) { return filePath.substring(filePath.lastIndexOf("/") + 1); }
	
	private String relativePath(String pBase, String pPath){
		return new File(pBase).toURI().relativize(new File(pPath).toURI()).getPath();
	}
}
