package nl.oostnl.ventureplan.jobs.financial;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Properties;

public class FinancialDataset  implements Dataset{
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private Properties iProperties;

	public FinancialDataset() {
		//nothing for now
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getCreate()
	 */
	@Override
	public Operation getCreate() throws OperationException {
		/* nothin for now*/
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getRead()
	 */
	@Override
	public Operation getRead() throws OperationException {
		/* nothin for now*/
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getUpdate()
	 */
	@Override
	public Operation getUpdate() throws OperationException {
		/* nothin for now*/
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getDelete()
	 */
	@Override
	public Operation getDelete() throws OperationException {
		/* nothin for now*/
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getList()
	 */
	@Override
	public Operation getList() throws OperationException {
		/* nothin for now*/
		return null;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#listOperations()
	 */
	@Override
	public List<String> listOperations() {
		List<String> lRetVal=new ArrayList<>();
		lRetVal.add("Import");
		return lRetVal;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getOperation(java.lang.String)
	 */
	@Override
	public Operation getOperation(String pOperation) throws OperationException {
		Operation lOperation=null;
		switch(pOperation){
		case "Import":
			lOperation=new ImportFinancial();lOperation.setProperties(iProperties);break;
		default: lOperation=null;
		}
		return lOperation;
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#setProperties(nl.knowledgeplaza.util.Properties)
	 */
	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;

	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getDescription()
	 */
	@Override
	public String getDescription() {
		return "Synchronizes data to Dynamics";
	}

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Dataset#getDocumentation()
	 */
	@Override
	public String getDocumentation() {
		ClassLoader classLoader = getClass().getClassLoader();
		InputStream lDocStream=classLoader.getResourceAsStream("financial/documentation.md");
		try {
			return IOUtil.toString(lDocStream);
		} catch (IOException e) {
			log4j.error("Could not get documentation",e);
		}
		return null;
	}
}
