/**
 * 
 */
package nl.oostnl.ventureplan.jobs.finfact;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Properties;

/**
 * @author stpl
 *
 */
public class FinfactDataset implements Dataset {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(FinfactDataset.class);

	private Properties iProperties=null;
	

	/**
	 * 
	 */
	public FinfactDataset() {
		/* nothing for now*/
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getCreate()
	 */
	@Override
	public Operation getCreate() throws OperationException {
		return null;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getRead()
	 */
	@Override
	public Operation getRead() throws OperationException {
		return null;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getUpdate()
	 */
	@Override
	public Operation getUpdate() throws OperationException {
		return null;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getDelete()
	 */
	@Override
	public Operation getDelete() throws OperationException {
		return null;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getList()
	 */
	@Override
	public Operation getList() throws OperationException {
		return null;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#listOperations()
	 */
	@Override
	public List<String> listOperations() {
		List<String> lRetVal=new ArrayList<>();
		lRetVal.add("GenerateFactuur");
		lRetVal.add("MergeFactuur");
		lRetVal.add("DailyFinfact");
		return lRetVal;	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getOperation(java.lang.String)
	 */
	@Override
	public Operation getOperation(String pOperation) throws OperationException {
		Operation lRet=null;
		switch(pOperation){
			case "GenerateFactuur": lRet= new GenerateFactuur();lRet.setProperties(iProperties);break;
			case "MergeFactuur": lRet= new MergeFactuur();lRet.setProperties(iProperties);break;
			case "DailyFinfact": lRet= new DailyFinfact();lRet.setProperties(iProperties);break;
			default: lRet=null;
		}
		return lRet;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#setProperties(nl.knowledgeplaza.util.Properties)
	 */
	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;

	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getDescription()
	 */
	@Override
	public String getDescription() {
		return "Jobs regarding fin.facts";
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Dataset#getDocumentation()
	 */
	@Override
	public String getDocumentation() {
		ClassLoader classLoader = getClass().getClassLoader();
		InputStream lDocStream=classLoader.getResourceAsStream("finfact/documentation.md");
		try {
			return IOUtil.toString(lDocStream);
		} catch (IOException e) {
			log4j.error("Could not get documentation",e);
		}
		return null;	
	}

}
