package nl.oostnl.ventureplan.jobs.finfact;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.log4j.Logger;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.groenfonds.jobs.interest.MonthylyInterestRevenueOperation;
import nl.innovationinvestments.cheyenne.daemon.utils.DocStore;
import nl.innovationinvestments.pdfconversie.ConvertWordToPdf;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.FileUtil;
import nl.knowledgeplaza.util.Properties;

public class MergeFactuur implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.7 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(MonthylyInterestRevenueOperation.class);

	private static final String cRunDate = "rundate";
	private static final String cUserId = "user_id";
	private static final String cMedewerkerId = "medewerker_id";

	private Dataset iDataset;
	private Map<String,Object> iParams;
	private Properties iProperties;
	private Dataset iDsFactuur=null;
	
	private XamEngine iXE=null;

	private HttpClient client; //stpl test: was static
	private static MultiThreadedHttpConnectionManager connMan;
	private String iLocalBase=null;
	private String iSession=null;

	/**
	 * @throws OperationException 
	 * 
	 */
	public MergeFactuur() throws OperationException {
		super();
		iXE=new XamEngine();
		iParams=new HashMap<>();
		try {
			iDsFactuur=iXE.getDataset("Factuur");
		} catch (DatasetException e) {
			throw new OperationException(e);
		}
		
		connMan = new MultiThreadedHttpConnectionManager();
		client= new HttpClient(connMan);
		
		iLocalBase = ConfigurationProperties.get().get("LOCAL_BASE");

	}

	@Override
	public Operator getOperator(String pName) {
		return null;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);

	}

	@Override
	public void setParameter(String pName, List<Object> pValue) {

	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean supportsResultset() {
		return true;
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		PROCESS_LOGGER.start("Merge facturen", 1);
		
		Operation lMerged = iDsFactuur.getOperation("ListMerged");
		lMerged.setParameter("status", Integer.valueOf(1));
		ResultSet lRSMerged = lMerged.executeAsResultset();
		
		Operation lSetMerged = iDsFactuur.getOperation("SetMerged");
		Operation lEmail = iDsFactuur.getOperation("CreateFactuurMail");
		
		String lFromEmail = ConfigurationProperties.get().get("Factuur.from.email");
		String lFromName = ConfigurationProperties.get().get("Factuur.from.name");
		String lBccName = ConfigurationProperties.get().get("Factuur.bcc");
		
		try {
			while (lRSMerged.next()){
				log4j.info("Merging facturen for run: " + lRSMerged.getInt("TASK_ID"));
				
				//haal de samen te voegen documenten op
				Operation lFactuur = iDsFactuur.getOperation("ListDocsByRun");
				lFactuur.setParameter("task_id", lRSMerged.getInt("TASK_ID"));
				lFactuur.setParameter("leningsoort", "");
				lFactuur.setParameter("type_finananciering", "");
				lFactuur.setParameter("im", "");
				lFactuur.setParameter("fonds", "");
				ResultSet lRCFacturen = lFactuur.executeAsResultset();
				
				//maak het bestemmingsdocument
				Operation lDocMerged = iDsFactuur.getOperation("CreateMergedDocument");
				Integer lMedewerker = Integer.parseInt((String)iParams.get(cMedewerkerId));
				lDocMerged.setParameter("rundate", (String)iParams.get(cRunDate));
				lDocMerged.setParameter("medewerker_id", lMedewerker);
				ResultSet lRCDoc = lDocMerged.executeAsResultset();
				
				
				
				String lDocstoreBase = ConfigurationProperties.get().get("DOCSTORE_BASE");
				
				PDFMergerUtility ut = new PDFMergerUtility();
				
				
				httpLogin();
				
				try {
					if (!lRCDoc.next()){
						throw new OperationException("Could not created merged document record");
					}
					
					Operation lUpdateTask = iDsFactuur.getOperation("UpdateTask");
					lUpdateTask.setParameter("task_id", lRSMerged.getInt("TASK_ID"));
					lUpdateTask.setParameter("doc_id", lRCDoc.getInt("p_doc_id"));
					lUpdateTask.executeAsValueMap();
					
					File lMergedPdf=File.createTempFile(lRCDoc.getString("title"), ".pdf");
					lMergedPdf.deleteOnExit();
					ut.setDestinationFileName(lMergedPdf.getAbsolutePath());
					
					log4j.info("Merged document path: " + lMergedPdf.getAbsolutePath());
					
					while (lRCFacturen.next()){
						//download document
						String lUrl = lDocstoreBase + lRCFacturen.getString("docstore_loc");
						lUrl +="?P_DOC_ID=" + lRCFacturen.getInt("doc_id");
						lUrl += "&sid=" + iSession;
						
						Boolean doMerge = lRCFacturen.getBoolean("DO_MERGE");
						//indien geen pdf, convert
						if (!lRCFacturen.getString("DOC_EXT").equals("pdf")){
							if(log4j.isDebugEnabled()) {
								log4j.debug("Get doc for url " + lUrl);
							}
							String lAttachmentName=FileUtil.removePath(lRCFacturen.getString("new_version_path"),'/');
							String pdfName=FileUtil.stripExtention(lAttachmentName)+".pdf";
							
							
							File lpdfDoc = File.createTempFile(pdfName,".pdftmp",null);
							lpdfDoc.deleteOnExit();
							
							File lDoc = File.createTempFile(lRCFacturen.getString("doc_name"),".docxtmp",null);
							
							FileUtil.copyURLToFile(new URL(lUrl), lDoc);
							
							if(log4j.isDebugEnabled()) {
								log4j.debug("--convert to: " + lpdfDoc.getAbsolutePath());
							}
							
							convertToPdf(lpdfDoc, lDoc);
							String docStoreLoc= FileUtil.getPath(lRCFacturen.getString("new_version_path"),'/') + "/";
							try {
								
								DocStore lDocstore = new DocStore(iSession);
								Part[] lParts= {
									new StringPart("URL",docStoreLoc),
									new StringPart("sid",iSession),
									new StringPart("P_DOC_ID",Integer.toString(lRCFacturen.getInt("doc_id"))),
									new FilePart(lpdfDoc.getName(), pdfName, lpdfDoc)
								};
								
								lDocstore.Store(lpdfDoc, lpdfDoc.getName(), lParts, docStoreLoc + "?cusername=" + lRCFacturen.getString("ug_name"));
								
							} catch (IOException e)
							{
								log4j.error("Error uploading generated document",e);
								throw new OperationException(e);
							}
							
							if (doMerge) {
								ut.addSource(lpdfDoc);
							} else {
								//Send factuur via email
								String encDocLocation = URLEncoder.encode(lDocstoreBase + docStoreLoc + "/" + pdfName, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
								String lFileUrl="jsp/callDocstore.jsp?url=" + encDocLocation;
								
								lEmail.setParameter("email_to", lRCFacturen.getString("o_email_adm"));
								lEmail.setParameter("email_from", lFromEmail);
								lEmail.setParameter("name_from", lFromName);
								if (lBccName!=null){
									lEmail.setParameter("email_bcc", lBccName);
								}
								
								//if resultset lRCFacturen has field o_email_adm2, use it
								try {
									lEmail.setParameter("email_cc", lRCFacturen.getString("o_email_adm2"));
								} catch (java.sql.SQLException e){
									//resultset lRCFacturen has no field o_email_adm2
									// do nothing
								}
								
								lEmail.setParameter("subject", "Factuur: " + lRCFacturen.getString("factuur_nr"));
								lEmail.setParameter("doc_name", FileUtil.stripExtention(lRCFacturen.getString("doc_name"))+".pdf");
								lEmail.setParameter("mail_url", "cddid=mail.factuur&cmode=mail/factuur&P_NOTA_ID=" + lRCFacturen.getInt("nota_id"));
								lEmail.setParameter("doc_url", lFileUrl);
								lEmail.setParameter("org_id", lRCFacturen.getInt("org_id"));
								lEmail.setParameter("doc_id", lRCFacturen.getInt("doc_id"));
								
								lEmail.executeAsValueMap();
							}
							
						} else {
							
							
							if(log4j.isDebugEnabled()) {
								log4j.debug("Get doc for url " + lUrl);
							}
							
							File lDoc = File.createTempFile(lRCFacturen.getString("doc_name") + ".pdf",".pdftmp",null);
							
							FileUtil.copyURLToFile(new URL(lUrl), lDoc);
							
							if (doMerge) {
								ut.addSource(lDoc);
							} else {
								//Send factuur via email
								String encDocLocation = URLEncoder.encode(lDocstoreBase + lRCFacturen.getString("docstore_loc"), StandardCharsets.UTF_8.toString());
								String lFileUrl="jsp/callDocstore.jsp?url=" + encDocLocation + "?cusername=" + lRCFacturen.getString("ug_name");
								
								lEmail.setParameter("email_to", lRCFacturen.getString("o_email_adm"));
								lEmail.setParameter("email_from", lFromEmail);
								lEmail.setParameter("name_from", lFromName);
								lEmail.setParameter("subject", "Factuur:" + lRCFacturen.getString("factuur_nr"));
								lEmail.setParameter("doc_name", lRCFacturen.getString("doc_name"));
								lEmail.setParameter("mail_url", "cddid=mail.factuur&cmode=mail/factuur&P_NOTA_ID=" + lRCFacturen.getInt("nota_id"));
								lEmail.setParameter("doc_url", lFileUrl);
								lEmail.setParameter("org_id", lRCFacturen.getInt("org_id"));
								lEmail.setParameter("doc_id", lRCFacturen.getInt("doc_id"));
								
								lEmail.executeAsValueMap();
							}
						}
						
						if(doMerge){
							lSetMerged.setParameter("nota_id", lRCFacturen.getInt("nota_id"));
							lSetMerged.setParameter("task_id", lRSMerged.getInt("TASK_ID"));
							lSetMerged.setParameter("merged", Integer.valueOf(1));
							lSetMerged.executeAsValueMap();
						}
					}
					//merge documenten
					ut.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
					
					//store in docstore
					DocStore lDocstore = new DocStore(iSession);
					Part[] lParts= {
						new StringPart("URL",lRCDoc.getString("P_DOC_ID") + "/"),
						new StringPart("sid",iSession),
						new StringPart("P_DOC_ID",lRCDoc.getString("P_DOC_ID")),
						new FilePart(lMergedPdf.getName(), lMergedPdf.getName(), lMergedPdf)
					};
					
					lDocstore.Store(lMergedPdf, lMergedPdf.getName(), lParts, "/" + lRCDoc.getString("P_DOC_ID") + "/" + "?cusername=" + getUserName(lMedewerker));
				} catch (SQLException | IOException e) {
					String message="Error merging facturen";
					log4j.error(message,e);
					throw new OperationException(message, e);
				} finally {
					//httpLogout();
				}
			}
		} catch (SQLException | NumberFormatException e) {
			String message="Error getting factuur runs";
			log4j.error(message,e);
			throw new OperationException(message, e);
		}
		PROCESS_LOGGER.complete("Merge facturen", 1);
		return null;
	}

	private String getUserName(Integer pMedewerker) throws OperationException {
		Dataset lMedewerker;
		try {
			lMedewerker = iXE.getDataset("Medewerker");
		} catch (DatasetException e) {
			throw new OperationException(e);
		}
		Operation lRead = lMedewerker.getRead();
		lRead.setParameter("medewerker_id", pMedewerker);
		ResultSet lRSMedewerker = lRead.executeAsResultset();
		try {
			if (!lRSMedewerker.next()){
				return "";
			}
			
			return lRSMedewerker.getString("ug_name");
		} catch (SQLException e) {
			log4j.error("Could not get username for medewerker " + pMedewerker);
			throw new OperationException("Could not get username for medewerker " + pMedewerker,e);
		}
	}

	private void convertToPdf(File lpdfDoc, File lDoc) throws FileNotFoundException, IOException {
		FileInputStream lIn=new FileInputStream(lDoc);
		FileOutputStream lOut=new FileOutputStream(lpdfDoc);
		
		try {
			ConvertWordToPdf.convert(lIn,lOut);
		} catch (Exception e) {
			throw new IOException(e);
		} finally {
			lOut.close();
			lIn.close();
		}
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		ResultSet lResult = this.executeAsResultset();
		log4j.info("Resultset: " + lResult);
		return null;
	}

	@Override
	public void close() {

	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;
	}

	@Override
	public void setDataset(Dataset pDataset) {
		iDataset = pDataset;
	}

	@Override
	public String getDescription() {
		return "Merges the yeraly account statements";
	}
	private void httpLogin() throws OperationException {
		String lUser = ConfigurationProperties.get().get("Cheyenne.username");
		String lPassword = ConfigurationProperties.get().get("Cheyenne.password");
		
		String lUrl=iLocalBase + "/cheyenne?cddid=main&cmode=kpwindow_ventureplan";
		lUrl+="&_username=" + lUser + "&_passwd=" + lPassword;
		if (log4j.isDebugEnabled()) log4j.debug("Logging in with url: " + lUrl);
		
		GetMethod get = new GetMethod(lUrl);
		try {
			int statusCode = client.executeMethod(get);
			
			if (statusCode != HttpStatus.SC_OK) {
		        log4j.error("Method failed: " + get.getStatusLine());
		        String lContent=get.getResponseBodyAsString();
		        log4j.info("Method body: \n" + lContent);
		        throw new OperationException("Method failed: " + get.getStatusLine());
		        
		      }
			else {
				//check cookies
				HttpState state = client.getState();
				Cookie lCookies[] = state.getCookies();

				for (Cookie lCookie : lCookies)
				{
					if (lCookie.getName().equals("JSESSIONID"))
					{
						log4j.info("Got session id: " + lCookie.getValue());
						iSession = lCookie.getValue();
					}
				}				
			}
		} catch ( IOException e ) {
			String msg ="Error logging in"; 
			log4j.error(msg,e);
			throw new OperationException(msg,e);
		} 
		
	}

	private void httpLogout() throws OperationException {
		String lUser = ConfigurationProperties.get().get("Cheyenne.username");
		String lPassword = ConfigurationProperties.get().get("Cheyenne.password");
		
		String lUrl=iLocalBase + "/jsp/logout.jsp";
		if (log4j.isDebugEnabled()) log4j.debug("Logging out with url: " + lUrl);
		
		GetMethod get = new GetMethod(lUrl);
		try {
			int statusCode = client.executeMethod(get);
			
			if (statusCode != HttpStatus.SC_OK) {
		        log4j.error("Method failed: " + get.getStatusLine());
		        String lContent=get.getResponseBodyAsString();
		        log4j.info("Method body: \n" + lContent);
		        throw new OperationException("Method failed: " + get.getStatusLine());
		        
		      }
		} catch ( IOException e ) {
			String msg ="Error logging in"; 
			log4j.error(msg,e);
			throw new OperationException(msg,e);
		} 
		
	}
}
