package nl.oostnl.ventureplan.jobs.kvk;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.nio.charset.StandardCharsets;

import org.apache.log4j.Logger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

// import net.sf.json.JSONObject; // Niet meer nodig, we gebruiken Jackson

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Properties;

public class GetBasisprofielOperation implements Operation {
	
	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private Map<String, Object> iParams;
	private Dataset iDataset;
	private Properties iProperties;
	private static final String corgkvk = "orgkvk";


	public GetBasisprofielOperation() {
		iParams = new HashMap<>();
	}

	@Override
	public boolean canExecute() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void close() {
		// TODO Auto-generated method stub

	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		
		/** set up a Log4J category to log in */
		URL url;
		Map<String, List<Object>> final_map = new HashMap();
		String kvk = null;
		
		

		try {
			if (log4j.isDebugEnabled()) {
				log4j.debug("executeAsValueMap() " );
			}
			List<Object> kvknummers = new ArrayList<>();
			List<Object> vestigingsnummer = new ArrayList<>();
			List<Object> rechtsvorm = new ArrayList<>();
			List<Object> bezoekadres = new ArrayList<>();
			List<Object> bezoekpostcode = new ArrayList<>();
			List<Object> bezoekplaats = new ArrayList<>();
			List<Object> bezoekland = new ArrayList<>();
			List<Object> postadres = new ArrayList<>();
			List<Object> postpostcode = new ArrayList<>();
			List<Object> postplaats = new ArrayList<>();
			List<Object> sbiCode = new ArrayList<>();
			List<Object> sbiCodeHoofd = new ArrayList<>();
			List<Object> sbiOmschrijving = new ArrayList<>();
			List<Object> datumAanvang = new ArrayList<>();
			List<Object> naam = new ArrayList<>();
			List<Object> fte = new ArrayList<>();
			List<Object> staturaireNaam = new ArrayList<>();
			List<Object> formeleregistratiedatum = new ArrayList<>();
			List<Object> website = new ArrayList<>();
			List<Object> rsin = new ArrayList<>();
			List<Object> btw = new ArrayList<>();
			List<Object> handelsnamen = new ArrayList<>();
			List<Object> toevoegingbezoek = new ArrayList<>();
			List<Object> toevoegingpost = new ArrayList<>();
			List<Object> organisationJson = new ArrayList<>();
			Map<String, Object> map = new HashMap<>();
			
			ArrayList list = new ArrayList<>();
			
			kvk = iParams.get(corgkvk).toString();
			map = getOrgDetails(kvk);
			kvknummers.add(map.get("kvkNummer"));
			vestigingsnummer.add(map.get("vestigingsnummer"));
			rechtsvorm.add(map.get("rechtsvorm"));
			bezoekadres.add(map.get("bezoekadres"));
			bezoekpostcode.add(map.get("bezoekpostcode"));
			bezoekplaats.add(map.get("bezoekplaats"));
			bezoekland.add(map.get("bezoekland"));
			postadres.add(map.get("postadres"));
			postpostcode.add(map.get("postpostcode"));
			postplaats.add(map.get("postplaats"));
			sbiCode.add(map.get("sbiCode"));
			sbiCodeHoofd.add(map.get("sbiCodeHoofd"));
			sbiOmschrijving.add(map.get("sbiOmschrijving"));
			datumAanvang.add(map.get("datumAanvang"));
			naam.add(map.get("naam"));
			fte.add(map.get("fte"));
			staturaireNaam.add(map.get("statutaireNaam"));
			formeleregistratiedatum.add(map.get("formeleRegistratiedatum"));
			website.add(map.get("website"));
			rsin.add(map.get("rsin"));
			btw.add(map.get("btw"));
			handelsnamen.add(map.get("handelsnamen"));
			toevoegingbezoek.add(map.get("bezoektoevoeging"));
			toevoegingpost.add(map.get("posttoevoeging"));

			final_map.put("kvknummer", kvknummers);
			final_map.put("vestigingsnummer", vestigingsnummer);
			final_map.put("rechtsvorm", rechtsvorm);
			final_map.put("bezoekadres", bezoekadres);
			final_map.put("bezoekpostcode", bezoekpostcode);
			final_map.put("bezoekplaats", bezoekplaats);
			final_map.put("bezoekland", bezoekland);
			final_map.put("postadres", postadres);
			final_map.put("postpostcode", postpostcode);
			final_map.put("postplaats", postplaats);
			final_map.put("sbiCode", sbiCode);
			final_map.put("sbiCodeHoofd", sbiCodeHoofd);
			final_map.put("sbiOmschrijving", sbiOmschrijving);
			final_map.put("datumAanvang", datumAanvang);
			final_map.put("naam", naam);
			final_map.put("fte", fte);
			final_map.put("statutaireNaam", staturaireNaam);
			final_map.put("formeleRegistratiedatum", formeleregistratiedatum);
			final_map.put("website",website);
			final_map.put("rsin",rsin);
			final_map.put("btw",btw);
			final_map.put("handelsnamen",handelsnamen);
			final_map.put("toevoegingbezoek",toevoegingbezoek);
			final_map.put("toevoegingpost",toevoegingpost);
			
			// Creëer een JSON object met alle velden met Jackson (behoudt null waarden)
			ObjectMapper objectMapper = new ObjectMapper();
			ObjectNode organisationJsonNode = objectMapper.createObjectNode();
			
			for (Map.Entry<String, Object> entry : map.entrySet()) {
				String key = entry.getKey();
				Object value = entry.getValue();
				
				// Voeg waarde toe aan het JSON object op basis van type
				if (value == null) {
					organisationJsonNode.putNull(key);
				} else if (value instanceof String) {
					organisationJsonNode.put(key, (String)value);
				} else if (value instanceof Integer) {
					organisationJsonNode.put(key, (Integer)value);
				} else if (value instanceof Long) {
					organisationJsonNode.put(key, (Long)value);
				} else if (value instanceof Double) {
					organisationJsonNode.put(key, (Double)value);
				} else if (value instanceof Boolean) {
					organisationJsonNode.put(key, (Boolean)value);
				} else {
					organisationJsonNode.put(key, value.toString());
				}
			}
			
			// Converteer naar BASE64 voor veilige overdracht
			String jsonString = objectMapper.writeValueAsString(organisationJsonNode);
			String base64Json = Base64.getEncoder().encodeToString(jsonString.getBytes(StandardCharsets.UTF_8));
			
			// Voeg toe aan de resultaatmap
			organisationJson.add(base64Json);
			final_map.put("organisationJson", organisationJson);
		} catch (Exception e) {
			log4j.error("Error fetching data",e);
			throw new OperationException("Error fetching data",e);
		}
		return final_map;

	}

	public Map<String, Object> getOrgDetails(String kvknummer) throws OperationException {
		URL url;
		Map<String, Object> map = new HashMap<>();
		
		String token = ConfigurationProperties.get().get("kvk.Key").toString();

		String url_string = ConfigurationProperties.get().get("kvk.Basisprofielurl").toString();
		
		if (log4j.isDebugEnabled()) {
			log4j.debug("Dynamics.key = " + token);
			log4j.debug("Dynamics.Addurl = " + url_string);
		}

		
		try {
			if (log4j.isDebugEnabled()) {
				log4j.debug("getOrgDetails() called" );
			}
			url = new URL(url_string + kvknummer);
			if (log4j.isDebugEnabled()) {
				log4j.debug("url called = " + url );
			}
			HttpURLConnection con = (HttpURLConnection) url.openConnection();
			con.setRequestMethod("GET");
			con.setRequestProperty("Cache-Control", "no-cache");
			con.setRequestProperty("User-Agent", "PostmanRuntime/7.26.2");
			con.setRequestProperty("Accept", "*/*");
			con.setRequestProperty("Connection", "keep-alive");
			con.setRequestProperty("Content-Type", "json");
			con.setRequestProperty("apikey", token);

			
			
			ObjectMapper mapper = new ObjectMapper();
			JsonNode root=mapper.readTree(con.getInputStream());
			
			if (log4j.isDebugEnabled())
			{
				log4j.debug("Resultaat: " + root);
			}
			
			JsonNode embedded = root.get("_embedded");
			JsonNode hoofdvestiging = embedded.get("hoofdvestiging");
			JsonNode eigenaar = embedded.get("eigenaar");
			
			/* bezoekadres */
			JsonNode service_answer_adressen = null;
			if (hoofdvestiging!=null) {
				service_answer_adressen=hoofdvestiging.get("adressen");
				if(log4j.isDebugEnabled())
				{
					log4j.debug("service_answer_adressen van hoofdvestiging: " + service_answer_adressen);
				}
			} else if (eigenaar!=null) {
				service_answer_adressen=eigenaar.get("adressen");
				if(log4j.isDebugEnabled())
				{
					log4j.debug("service_answer_adressen van eigenaar: " + service_answer_adressen);
				}
			}
			if (service_answer_adressen!=null){
				for (JsonNode adres : service_answer_adressen) {
					
					String type_adres = adres.get("type").asText();
					if(log4j.isDebugEnabled()) log4j.debug("type_adres: " + type_adres);
					
					if (type_adres.equals("bezoekadres")) {
						
						String adresStr=
								(adres.get("straatnaam").asText() + " " + adres.get("huisnummer"));
						// Huisletter toevoegen indien aanwezig
						if (adres.has("huisletter") && !adres.get("huisletter").asText().isEmpty()) {
							adresStr += adres.get("huisletter").asText();
						}
						
						map.put("bezoekadres",adresStr);
						map.put("bezoekpostcode", (adres.get("postcode").asText()));
						map.put("bezoekplaats", (adres.get("plaats").asText()));
						map.put("bezoekland", (adres.get("land").asText()));
						if(adres.has("toevoegingAdres")){
							map.put("bezoektoevoeging", (adres.get("toevoegingAdres").asText()));
						}
					} else if (type_adres.equalsIgnoreCase("Correspondentieadres")){
						String adresStr="";
						if (adres.has("postbusnummer")){
							adresStr="Postbus " + adres.get("postbusnummer").asText();
						} else if (adres.has("straatHuisnummer")){
							//buitenlands adres
							adresStr=adres.get("straatHuisnummer").asText();
						}
						 else {
							adresStr=
									(adres.get("straatnaam").asText() + " " + adres.get("huisnummer"));
							// Huisletter toevoegen indien aanwezig
							if (adres.has("huisletter") && !adres.get("huisletter").asText().isEmpty()) {
								adresStr += " " + adres.get("huisletter").asText();
							}
							// Toevoegingadres toevoegen indien aanwezig
							JsonNode toevoeging=adres.get("toevoegingAdres");
							if (toevoeging!=null && !toevoeging.asText().isEmpty()){
								map.put("posttoevoeging", toevoeging.asText());
							}
						}
						map.put("postadres",adresStr);
						if(adres.has("postcode")){
							map.put("postpostcode", (adres.get("postcode").asText()));
						}
						
						
						
						if(adres.has("postcodeWoonplaats")){
							String plaats=adres.get("postcodeWoonplaats").asText();
							if(adres.has("land")){
								plaats+=" " + adres.get("land").asText();
							}
							map.put("postplaats", plaats);
						} else {
							map.put("postplaats", (adres.get("plaats").asText()));
						}
					}

				}				
			}
				
			
			/* SBI Codes*/
			JsonNode hoofdactiviteit = root.get("sbiActiviteiten");
			String sbiCodes="";
			for (JsonNode act : hoofdactiviteit) {
				String type_sbi = act.get("indHoofdactiviteit").asText();
				sbiCodes += (sbiCodes.length()==0?"":", ") + act.get("sbiCode").asText();
				if (type_sbi.equals("Ja")) {
					map.put("sbiOmschrijving", (act.get("sbiOmschrijving").asText()));
					map.put("sbiCodeHoofd", act.get("sbiCode").asText());
				}
			}
			map.put("sbiCode", sbiCodes);
			
			JsonNode registratie = root.get("materieleRegistratie");
			if (registratie!=null) {
				String aanvang = getYearFromIsoDate(registratie.get("datumAanvang"));
				map.put("datumAanvang", aanvang);
			} 
			
			if (hoofdvestiging!=null && hoofdvestiging.has("vestigingsnummer"))
				map.put("vestigingsnummer", hoofdvestiging.get("vestigingsnummer").asText());
			if (eigenaar!=null && eigenaar.has("rechtsvorm"))
				map.put("rechtsvorm", eigenaar.get("rechtsvorm").asText());
			if (eigenaar!=null && eigenaar.has("rsin"))
				map.put("rsin", eigenaar.get("rsin").asText());
			if (eigenaar!=null && eigenaar.has("btw"))
				map.put("btw", eigenaar.get("btw").asText());

					
					
			map.put("naam", root.get("naam").asText());
			if (root.has("totaalWerkzamePersonen"))
				map.put("fte", root.get("totaalWerkzamePersonen"));
			
			map.put("kvkNummer", root.get("kvkNummer").asText());
			
			if(root.has("statutaireNaam"))
				map.put("statutaireNaam", root.get("statutaireNaam").asText());
			if (root.get("formeleRegistratiedatum")!=null){
				map.put("formeleRegistratiedatum", convertFromIsoDate(root.get("formeleRegistratiedatum")));
			} else if (registratie!=null) {
				map.put("formeleRegistratiedatum", convertFromIsoDate(registratie.get("datumAanvang")));
			}

			// Handelsnamen verzamelen
			StringBuilder handelsnamenBuilder = new StringBuilder();
			
			// Handelsnamen uit root
			if (root.has("handelsnamen") && root.get("handelsnamen").isArray()) {
				ArrayNode handelsnamenArray = (ArrayNode) root.get("handelsnamen");
				for (int i = 0; i < handelsnamenArray.size(); i++) {
					JsonNode handelsnaamObj = handelsnamenArray.get(i);
					if (handelsnaamObj.has("naam")) {
						if (i > 0) handelsnamenBuilder.append(", ");
						handelsnamenBuilder.append(handelsnaamObj.get("naam").asText());
					}
				}
			}
			
			// Handelsnamen uit hoofdvestiging (indien nog niet gevonden in root)
			if (handelsnamenBuilder.length() == 0 && hoofdvestiging != null && hoofdvestiging.has("handelsnamen") && hoofdvestiging.get("handelsnamen").isArray()) {
				ArrayNode handelsnamenArray = (ArrayNode) hoofdvestiging.get("handelsnamen");
				for (int i = 0; i < handelsnamenArray.size(); i++) {
					JsonNode handelsnaamObj = handelsnamenArray.get(i);
					if (handelsnaamObj.has("naam")) {
						if (i > 0) handelsnamenBuilder.append(", ");
						handelsnamenBuilder.append(handelsnaamObj.get("naam").asText());
					}
				}
			}
			
			// Handelsnamen uit eigenaar (indien nog niet gevonden in root of hoofdvestiging)
			if (handelsnamenBuilder.length() == 0 && eigenaar != null && eigenaar.has("handelsnamen") && eigenaar.get("handelsnamen").isArray()) {
				ArrayNode handelsnamenArray = (ArrayNode) eigenaar.get("handelsnamen");
				for (int i = 0; i < handelsnamenArray.size(); i++) {
					JsonNode handelsnaamObj = handelsnamenArray.get(i);
					if (handelsnaamObj.has("naam")) {
						if (i > 0) handelsnamenBuilder.append(", ");
						handelsnamenBuilder.append(handelsnaamObj.get("naam").asText());
					}
				}
			}
			
			if (handelsnamenBuilder.length() > 0) {
				map.put("handelsnamen", handelsnamenBuilder.toString());
			}
			
			// Website ophalen
			if (hoofdvestiging!=null && hoofdvestiging.has("websites") && hoofdvestiging.get("websites").isArray() && hoofdvestiging.get("websites").get(0)!=null){
				map.put("website", hoofdvestiging.get("websites").get(0).asText() );
			}

		} catch (Exception e) {
			log4j.error("Error fetching data",e);
			throw new OperationException("Error fetching data",e);
		}
		return map;

	}

	static String convertFromIsoDate(JsonNode pDate){
		if (pDate==null){
			return "";
		}
		String val=pDate.asText();
		if (val.contains("T")){
			LocalDateTime date=LocalDateTime.parse(val);
			DateTimeFormatter formatter=DateTimeFormatter.ofPattern("dd-MM-yyyy");
			return date.format(formatter);	
		} else {
			LocalDate date=LocalDate.parse(val, DateTimeFormatter.BASIC_ISO_DATE);
			DateTimeFormatter formatter=DateTimeFormatter.ofPattern("dd-MM-yyyy");
			return date.format(formatter);
		}
	
	}
	
	static String getYearFromIsoDate(JsonNode pDate){
		if (pDate==null){
			return "";
		}
		String val=pDate.asText();
		if (val.contains("T")){
			LocalDateTime date=LocalDateTime.parse(val);
			DateTimeFormatter formatter=DateTimeFormatter.ofPattern("yyyy");
			return date.format(formatter);	
		} else {
			LocalDate date=LocalDate.parse(val, DateTimeFormatter.BASIC_ISO_DATE);
			DateTimeFormatter formatter=DateTimeFormatter.ofPattern("yyyy");
			return date.format(formatter);
		}
	
	}
		

	@Override
	public String getDescription() {
		return "Get info from basisprofiel list from search";
	}

	@Override
	public Operator getOperator(String arg0) {
		// TODO Auto-generated method stub
		return null;
		
	}

	@Override
	public void setDataset(Dataset pDS) {
		// TODO Auto-generated method stub
		iDataset = pDS;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		// TODO Auto-generated method stub
		iParams.put(pName, pValue);
	}

	@Override
	public void setParameter(String arg0, List<Object> arg1) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setProperties(Properties pProperties) {
		// TODO Auto-generated method stub
		iProperties = pProperties;
	}

	@Override
	public boolean supportsResultset() {
		// TODO Auto-generated method stub
		return false;
	}

}
