package nl.oostnl.ventureplan.jobs.kvk;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.json.Json;

import org.apache.log4j.Logger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Properties;

public class OrganisationSearchOperation implements Operation {
	
	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private Map<String, Object> iParams;
	private Dataset iDataset;
	private Properties iProperties;
	private static final String corgnaam = "orgnaam";
	private static final String corgplaats = "orgplaats";
	private static final String corgkvk = "orgkvk";

	public OrganisationSearchOperation() {
		iParams = new HashMap<>();
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public void close() {
		// TODO Auto-generated method stub

	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		String orgnaam = null;
		String orgplaats = null;
		String orgkvk = null;

		orgplaats = iParams.get(corgplaats).toString();
		orgnaam = iParams.get(corgnaam).toString();
		orgkvk = iParams.get(corgkvk).toString();

		String token = ConfigurationProperties.get().get("kvk.Key").toString();
		String aantal_resultaten = ConfigurationProperties.get().get("kvk.AantalResultaten").toString();
		String url_string = ConfigurationProperties.get().get("kvk.Searchurl").toString();

		if (log4j.isDebugEnabled()) {
			log4j.debug("Kvk.key = " + token);
			log4j.debug("Kvk.Addurl = " + url_string);
		}

		String url_search = null;
		boolean isFirst = true;
		try {
			if (orgnaam.isEmpty() == false) {
				if (isFirst == true) {
					url_search = "?naam=" + URLEncoder.encode(orgnaam, "UTF-8");
					isFirst = false;
				} else {
					url_search = url_search + "&naam=" + URLEncoder.encode(orgnaam, "UTF-8");
				}
			}
			if (orgplaats.isEmpty() == false) {
				if (isFirst == true) {
					url_search = url_search + "?plaats=" + URLEncoder.encode(orgplaats, "UTF-8");
					isFirst = false;
				} else {
					url_search = url_search + "&plaats=" + URLEncoder.encode(orgplaats, "UTF-8");
				}
			}
			if (orgkvk.isEmpty() == false) {
				if (isFirst == true) {
					url_search = "?kvkNummer=" + URLEncoder.encode(orgkvk, "UTF-8");
					isFirst = false;
				} else {
					url_search = url_search + "&kvkNummer=" + URLEncoder.encode(orgkvk, "UTF-8");
				}
			}
		} catch (UnsupportedEncodingException e) {
			throw new OperationException(e);
		}
		
		if (log4j.isDebugEnabled()) {
			log4j.debug("created url based on filters = " + url_search + "&resultatenPerPagina=" + aantal_resultaten);
		}
		URL url;
		Map<String, List<Object>> final_map = new HashMap<>();
		HttpURLConnection con=null;
		List<Object> kvknummer = new ArrayList<>();
		List<Object> adres = new ArrayList<>();
		List<Object> type = new ArrayList<>();
		List<Object> plaats = new ArrayList<>();
		List<Object> naam = new ArrayList<>();
		List<Object> vestigingsnummer = new ArrayList<>();
		List<Object> postcode = new ArrayList<>();
		
		try {
			url = new URL(url_string + url_search);
			if (log4j.isDebugEnabled()) {
				log4j.debug("url called = " + url );
			}
			con = (HttpURLConnection) url.openConnection();
			con.setRequestMethod("GET");
			con.setRequestProperty("Cache-Control", "no-cache");
			con.setRequestProperty("User-Agent", "PostmanRuntime/7.26.2");
			con.setRequestProperty("Accept", "*/*");
			con.setRequestProperty("Connection", "keep-alive");
			con.setRequestProperty("Content-Type", "json");
			con.setRequestProperty("apikey", token);
			
			

			
			
			ObjectMapper mapper = new ObjectMapper();
			JsonNode root=mapper.readTree(con.getInputStream());
			
			JsonNode service_answer = root.get("resultaten");

			if (log4j.isDebugEnabled())
			{
				log4j.debug("Resultaat: " + service_answer);
			}

			/* get all kvk nummers */

			for (JsonNode orgs :service_answer ) {
				if (orgs.get("kvkNummer")!=null) {
					kvknummer.add(orgs.get("kvkNummer").textValue());
				} else {
					kvknummer.add("");
				}
				
				if (orgs.get("naam")!=null) {
					naam.add(orgs.get("naam").textValue());
				} else {
					naam.add("");
				}
				
				
				
				if (orgs.get("vestigingsnummer")!=null) {
					vestigingsnummer.add(orgs.get("vestigingsnummer").textValue());
				} else {
					vestigingsnummer.add("");
				}
				
				

				//haal het adres op
				JsonNode adresTussen = orgs.get("adres");
				JsonNode adresNode = null;
				if(adresTussen!=null && adresTussen.get("binnenlandsAdres") != null) {
					adresNode = adresTussen.get("binnenlandsAdres");
					if(adresNode != null) {
					
						if (adresNode.get("type")!=null){
							type.add(adresNode.get("type").textValue());
						} else {
							type.add("");
						}
						if (adresNode.get("straatnaam")!=null){
							adres.add(adresNode.get("straatnaam").textValue());
						} else {
							adres.add("");
						}
						if (adresNode.get("plaats")!=null) { 
							plaats.add(adresNode.get("plaats").textValue());
						} else {
							plaats.add("");
						}
						
						// Extract postcode
						if (adresNode.get("postcode")!=null) { 
							postcode.add(adresNode.get("postcode").textValue());
						} else {
							postcode.add("");
						}
	
					}
				} else if(adresTussen!=null && adresTussen.get("buitenlandsAdres") != null) {
					adresNode = adresTussen.get("buitenlandsAdres");
					if(adresNode != null) {
					
						if (adresNode.get("type")!=null){
							type.add(adresNode.get("type").textValue());
						} else {
							type.add("");
						}
						if (adresNode.get("straatHuisnummer")!=null){
							adres.add(adresNode.get("straatHuisnummer").textValue());
						} else {
							adres.add("");
						}
						if (adresNode.get("postcodeWoonplaats")!=null) { 
							plaats.add(adresNode.get("postcodeWoonplaats").textValue());
						} else {
							plaats.add("");
						}
						
						// For foreign addresses, we might not have a separate postcode field
						postcode.add("");
	
					}
				} else {
					type.add("");
					adres.add("");
					plaats.add("");
					postcode.add("");
				}
				
			}
			final_map.put("kvknummer", kvknummer);
			final_map.put("adres", adres);
			final_map.put("type", type);
			final_map.put("plaats", plaats);
			final_map.put("naam", naam);
			final_map.put("vestigingsnummer", vestigingsnummer);
			final_map.put("postcode", postcode);
		} catch (FileNotFoundException e){
			
			int responseCode;
			try {
				responseCode = con.getResponseCode();
				if (responseCode==404){
					//not found return empty list
					final_map.put("kvknummer", kvknummer);
					final_map.put("adres", adres);
					final_map.put("type", type);
					final_map.put("plaats", plaats);
					final_map.put("naam", naam);
					final_map.put("vestigingsnummer", vestigingsnummer);
					final_map.put("postcode", postcode);
					return final_map;
				}
			} catch (IOException e1) {
				log4j.error("Error fetching data",e);
				throw new OperationException("Error fetching data",e);
			}
			
			
		} catch (Exception e) {
			log4j.error("Error fetching data",e);
			throw new OperationException("Error fetching data",e);
		}
		return final_map;
	}

	@Override
	public String getDescription() {
		return "Get list of organisations based of search";
	}

	@Override
	public Operator getOperator(String arg0) {
		return null;
	}

	@Override
	public void setDataset(Dataset pDS) {
		iDataset = pDS;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);
	}

	@Override
	public void setParameter(String arg0, List<Object> arg1) {

	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;
	}

	@Override
	public boolean supportsResultset() {
		return false;
	}

}
