package nl.oostnl.ventureplan.jobs.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;

import javax.activation.MimetypesFileTypeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.OperationException;
import nl.groenfonds.jobs.CheyenneLogin;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.IOUtil;

@Entity
@Table(name="vp_document")
public class VpDocument extends CheyenneLogin implements Closeable{
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();
	private InputStream iStream=null;
	private String sessionId=null;
	
	@Id
	@Column(name="doc_id")
	private Integer docId;
	
	@Column(name="org_id")
	private Integer orgId;
	
	@Column(name="proj_id")
	private Integer projId;
	
	@Column(name="fr_id")
	private Integer frId;
	
	@Column(name="docname")
	private String docName;
	
	@Column(name="docstore_loc")
	private String docstoreLocation;
	
	@Column(name="current_version_id")
	private Integer currentVersionId;

	public Integer getDocId() {
		return docId;
	}

	public void setDocId(Integer pDocId) {
		docId = pDocId;
	}

	public Integer getOrgId() {
		return orgId;
	}

	public void setOrgId(Integer pOrgId) {
		orgId = pOrgId;
	}

	public Integer getProjId() {
		return projId;
	}

	public void setProjId(Integer pProjId) {
		projId = pProjId;
	}

	public Integer getFrId() {
		return frId;
	}

	public void setFrId(Integer pFrId) {
		frId = pFrId;
	}

	public String getDocName() {
		return docName;
	}

	public void setDocName(String pDocName) {
		docName = pDocName;
	}

	public String getDocstoreLocation() {
		return docstoreLocation;
	}

	public void setDocstoreLocation(String pDocstoreLocation) {
		docstoreLocation = pDocstoreLocation;
	}
	
	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String pSessionId) {
		sessionId = pSessionId;
	}
	
	public InputStream getFileStream() throws OperationException{
		if (iStream==null) {
			String lSessionId=sessionId;
			if (lSessionId==null) {
				httpLogin();
				lSessionId=getSession();
			}
			
			String contentUrl=ConfigurationProperties.get().get("LOCAL_BASE");
			String lDocstoreBase = ConfigurationProperties.get().get("DOCSTORE_BASE");
			contentUrl+="jsp/callDocstore.jsp;jsessionid=" + lSessionId + '?';
			
			if (docstoreLocation.endsWith(".fo")) {
				contentUrl+="xslfo=docx&";
			}
			
			
			
			try {
				contentUrl+="url=" + URLEncoder.encode(lDocstoreBase + docstoreLocation,"UTF-8") + '&';
				contentUrl+="mimeType=" + getContentType(null);
				contentUrl+="&P_DOC_ID=" + getDocId();
				if(log4j.isDebugEnabled()) {
					log4j.debug("Get doc for url " + contentUrl);
				}
				URL ldocLoc=new URL(contentUrl);
				iStream = ldocLoc.openStream();
			} catch ( IOException e) {
				log4j.error("Could not get file",e);
				throw new OperationException(e);
			}
		}
		
		return iStream;
	}
	
	public String getContentType(String pArg0) {
		if (log4j.isInfoEnabled()) log4j.info(String.format("ChyDocumentResource.getContentType called - pArg0=%1$s",pArg0));
		String file=getDocName();
		String mime=null;
		if (file.endsWith("docx")){
			mime="application/vnd.openxmlformats-officedocument.wordprocessingml.document";
		} else {
			MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
			mime= fileTypeMap.getContentType(file);
		}
		//if no mimetype is found then return a default mimetype
		if (mime==null){
			mime="application/octet-stream";
		}
		if (log4j.isDebugEnabled()) log4j.debug("file:" + file + " mime:" + mime);
		if (log4j.isInfoEnabled()) log4j.info(String.format("ChyDocumentResource.getContentType returns - value=%1$s",mime));
		return mime;
	}
	
	@Override
	public void close() throws IOException {
		try {
			IOUtil.close(iStream);
			httpLogout();
		} catch (OperationException e) {
			log4j.error("Coud not close",e);
		}
	}

	public Integer getCurrentVersionId() {
		return currentVersionId;
	}

	public void setCurrentVersionId(Integer pCurrentVersionId) {
		currentVersionId = pCurrentVersionId;
	}

	@Override
	public String toString() {
		StringBuilder lBuilder = new StringBuilder();
		lBuilder.append("VpDocument [iStream=").append(iStream).append(", sessionId=").append(sessionId)
				.append(", docId=").append(docId).append(", orgId=").append(orgId).append(", projId=").append(projId)
				.append(", frId=").append(frId).append(", docName=").append(docName).append(", docstoreLocation=")
				.append(docstoreLocation).append(", currentVersionId=").append(currentVersionId).append("]");
		return lBuilder.toString();
	}

}
