package nl.oostnl.ventureplan.jobs.onboarding.operation;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

 

import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.Properties;
import nl.oostnl.ventureplan.jobs.onboarding.adapter.QueueDao;
import nl.oostnl.ventureplan.jobs.onboarding.domain.AanvraagQueueItem;
import nl.oostnl.ventureplan.jobs.onboarding.domain.ProcessingResult;
import nl.oostnl.ventureplan.jobs.onboarding.service.ItemProcessor;
 

public class ProcessQueueOperation implements Operation {
	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();
	
    private Map<String, Object> params = new HashMap<>();
    private Properties properties;

    @Override
    public boolean canExecute() { return true; }

    @Override
    public void close() { }

    @Override
    public ResultSet executeAsResultset() throws OperationException { return null; }

    @Override
    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        int limit = parseInt(params.get("limit"), 10);
        long start = System.currentTimeMillis();

        log4j.info("Processing queue with limit " + limit);

        QueueDao dao = new QueueDao(properties);
        List<AanvraagQueueItem> items = dao.fetchNextBatch(limit);
        long claimed = items == null ? 0L : items.size();
        long completed = 0L;
        long rejected = 0L;

        ItemProcessor processor = new ItemProcessor(properties);
        if (items != null) {
            for (AanvraagQueueItem it : items) {
						log4j.info("========================================================================================");
                log4j.info("Processing item " + it);
                ProcessingResult res = processor.process(it);
                log4j.info("Processing result " + res);
                if (res != null && res.getStatus() == ProcessingResult.Status.SUCCESS) {
                    log4j.info("Marking completed " + it.getQueueId());
                    dao.markCompleted(it.getQueueId());
                    completed++;
                } else {
                    log4j.info("Marking rejected " + it.getQueueId());
                    String errCode = res == null ? null : res.getErrorCode();
                    String errMsg  = res == null ? null : res.getErrorMessage();
                    dao.markRejected(it.getQueueId(), errCode, errMsg);
                    rejected++;
                }
            }
        }

        long duration = System.currentTimeMillis() - start;
			log4j.info("========================================================================================");
        Map<String, Object> row = new HashMap<String, Object>();
        row.put("claimed", claimed);
        row.put("completed", completed);
        row.put("rejected", rejected);
        row.put("duration_ms", duration);
        List<Map<String, Object>> out = new java.util.ArrayList<Map<String, Object>>();
        out.add(row);
				log4j.info("Result " + row);
				log4j.info("========================================================================================");
        return out;
    }

    @Override
    public Map<String, List<Object>> executeAsValueMap() throws OperationException { 
        return new HashMap<String, List<Object>>();
    }

    private int parseInt(Object o, int def) {
        if (o == null) return def;
        try { return Integer.parseInt(String.valueOf(o)); } catch (Exception e) { return def; }
    }

    @Override
    public String getDescription() { return "Process onboarding queue"; }

    @Override
    public Operator getOperator(String arg0) { return null; }

    @Override
    public void setDataset(nl.buildersenperformers.xam.engine.Dataset pDS) { /* not used */ }

    @Override
    public void setParameter(String name, Object value) throws OperationException { params.put(name, value); }

    @Override
    public void setParameter(String name, List<Object> values) { }

    @Override
    public void setProperties(Properties pProperties) { this.properties = pProperties; }

    @Override
    public boolean supportsResultset() { return false; }
}
