/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.innovationinvestments.docstore.storage.FileContainer;
import nl.innovationinvestments.docstore.storage.FilesContainer;
import nl.innovationinvestments.docstore.storage.Storage;
import nl.innovationinvestments.docstore.storage.StorageFilesystem;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import nl.knowledgeplaza.util.StringUtil;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

public class ListDiffDocstore
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.3 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(ListDiffDocstore.class);
    private Properties iProperties;
    private Map<String, Object> iParams;
    private List<String> iPathCache;
    private XamEngine iXE = new XamEngine();
    private Dataset iDsDocuments = null;
    private Dataset iDataset;
    private String iDocstoreBase = null;

    public ListDiffDocstore() {
        try {
            this.iDsDocuments = this.iXE.getDataset("Documents");
        }
        catch (DatasetException e) {
            throw new RuntimeException(e);
        }
        this.iParams = new HashMap<String, Object>();
        this.iPathCache = new ArrayList<String>();
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return false;
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        ArrayList<Map<String, Object>> lRetVal = new ArrayList<Map<String, Object>>();
        String lProc = "Diff van documents";
        PROCESS_LOGGER.start(lProc);
        Operation lListDocs = null;
        if (this.iParams.containsKey("org_id")) {
            lListDocs = this.iDsDocuments.getOperation("ListGenDocumentsByOrg");
            lListDocs.setParameter("org_id", (Object)((String)this.iParams.get("org_id")));
        } else {
            if (!this.iParams.containsKey("doc_id")) {
                throw new OperationException("no org_id or doc_id parameter set");
            }
            lListDocs = this.iDsDocuments.getOperation("ListGenDocuments");
            lListDocs.setParameter("doc_id", (Object)new Integer((String)this.iParams.get("doc_id")));
        }
        ResultSet lResDocs = lListDocs.executeAsResultset();
        String lBase = (String)this.iParams.get("base");
        String lDocstoreConfigpPath = (String)this.iParams.get("docstoreConfig");
        FileWriter lWriter = null;
        BufferedWriter lBWriter = null;
        try {
            lWriter = new FileWriter((String)this.iParams.get("resultFile"));
            lBWriter = new BufferedWriter(lWriter);
        }
        catch (IOException e1) {
            throw new OperationException((Throwable)e1);
        }
        Storage lStorage = this.getStorage(lDocstoreConfigpPath, lBase);
        try {
            while (lResDocs.next()) {
                FilesContainer lFilesContainer = this.createFilesContainer(lResDocs.getString("name"), null);
                FilesContainer lFilesContainerResult = null;
                try {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"Handing over to storage.select");
                    }
                    lFilesContainerResult = lStorage.select(lFilesContainer);
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"Back from storage...");
                    }
                    if (lFilesContainerResult.files.size() != 1 || ((FileContainer)lFilesContainerResult.files.get((int)0)).inputStream == null || !(((FileContainer)lFilesContainerResult.files.get((int)0)).inputStream instanceof FileInputStream)) continue;
                    String file = ((FileContainer)lFilesContainerResult.files.get((int)0)).localPathName;
                    String relFile = this.relativePath(this.iDocstoreBase, file);
                    String relPath = "";
                    for (String lpart : relFile.split("\\/")) {
                        if (!this.iPathCache.contains(relPath = relPath + lpart)) {
                            this.iPathCache.add(relPath);
                            File lFile = new File(this.iDocstoreBase + "/" + relPath);
                            if (!lFile.isDirectory()) {
                                lBWriter.write(relPath);
                                lBWriter.newLine();
                            }
                            String propFile = relPath + ".properties";
                            lBWriter.write(propFile);
                            lBWriter.newLine();
                        }
                        relPath = relPath + "/";
                    }
                }
                catch (Throwable t) {
                    if (!this.iParams.containsKey("logFileErrors")) continue;
                    log4j.warn((Object)"Error getting file", t);
                }
            }
            lBWriter.close();
            lWriter.close();
        }
        catch (IOException | SQLException e) {
            throw new OperationException((Throwable)e);
        }
        PROCESS_LOGGER.complete(lProc);
        return lRetVal;
    }

    private Storage getStorage(String pDocstoreConfigpPath, String pBase) {
        File[] lConfigFiles = new File[]{new File(pDocstoreConfigpPath)};
        ConfigurationProperties lConfig = new ConfigurationProperties(lConfigFiles);
        ConfigurationProperties.set((ConfigurationProperties)lConfig);
        StorageFilesystem lStorage = null;
        String lStorageId = pBase;
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("storage '" + lStorageId + "'"));
        }
        if (StringUtil.isEmpty((String)lStorageId)) {
            throw new IllegalArgumentException("Could not determine the storage to use");
        }
        String lStorageType = lConfig.get2((Object)this, lStorageId + ".type");
        this.iDocstoreBase = lConfig.get2((Object)this, lStorageId + ".basedir");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("storage '" + lStorageId + "' type=" + lStorageType));
        }
        if (!"FileSystem".equals(lStorageType)) {
            throw new IllegalStateException("Unknown storagetype: " + lStorageType);
        }
        lStorage = new StorageFilesystem(lStorageId);
        return lStorage;
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDataset) {
        this.iDataset = pDataset;
    }

    public String getDescription() {
        return "List of files from docstore since doc_id";
    }

    private FilesContainer createFilesContainer(String pName, List<FileItem> fileItems) throws IOException {
        String lFilePath = pName;
        String lDirName = null;
        String lFileName = null;
        if (lFilePath.endsWith("/")) {
            lDirName = lFilePath;
        } else {
            lDirName = this.extractDirName(lFilePath);
            lFileName = this.extractFileName(lFilePath);
        }
        FilesContainer lFilesContainer = new FilesContainer();
        lFilesContainer.dirName = lDirName;
        if (fileItems != null) {
            for (FileItem lFileItem : fileItems) {
                if (lFileItem.isFormField()) {
                    lFilesContainer.properties.put(lFileItem.getFieldName(), lFileItem.getString());
                    continue;
                }
                FileContainer lFileContainer = new FileContainer();
                lFileContainer.inputStream = lFileItem.getInputStream();
                lFileContainer.name = lFileName != null ? lFileName : new File(lFileItem.getName()).getName();
                lFileContainer.contentType = lFileItem.getContentType();
                lFileContainer.size = lFileItem.getSize();
                lFileContainer.fieldname = lFileItem.getFieldName();
                lFileContainer.localPathName = lFileItem.getName();
                lFilesContainer.files.add(lFileContainer);
            }
        }
        if (lFileName != null && lFilesContainer.files.size() == 0) {
            FileContainer lFileContainer = new FileContainer();
            lFileContainer.name = lFileName;
            lFilesContainer.files.add(lFileContainer);
        }
        return lFilesContainer;
    }

    private String extractDirName(String filePath) {
        return filePath.substring(0, filePath.lastIndexOf("/") + 1);
    }

    private String extractFileName(String filePath) {
        return filePath.substring(filePath.lastIndexOf("/") + 1);
    }

    private String relativePath(String pBase, String pPath) {
        return new File(pBase).toURI().relativize(new File(pPath).toURI()).getPath();
    }
}

