/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.kvk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import org.apache.log4j.Logger;

public class OrganisationSearchOperation
implements Operation {
    private static Logger log4j = Log4jUtil.createLogger();
    private Map<String, Object> iParams = new HashMap<String, Object>();
    private Dataset iDataset;
    private Properties iProperties;
    private static final String corgnaam = "orgnaam";
    private static final String corgplaats = "orgplaats";
    private static final String corgkvk = "orgkvk";

    public boolean canExecute() {
        return true;
    }

    public void close() {
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        String orgnaam = null;
        String orgplaats = null;
        String orgkvk = null;
        orgplaats = this.iParams.get(corgplaats).toString();
        orgnaam = this.iParams.get(corgnaam).toString();
        orgkvk = this.iParams.get(corgkvk).toString();
        String token = ConfigurationProperties.get().get("kvk.Key").toString();
        String aantal_resultaten = ConfigurationProperties.get().get("kvk.AantalResultaten").toString();
        String url_string = ConfigurationProperties.get().get("kvk.Searchurl").toString();
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Kvk.key = " + token));
            log4j.debug((Object)("Kvk.Addurl = " + url_string));
        }
        String url_search = null;
        boolean isFirst = true;
        try {
            if (!orgnaam.isEmpty()) {
                if (isFirst) {
                    url_search = "?naam=" + URLEncoder.encode(orgnaam, "UTF-8");
                    isFirst = false;
                } else {
                    url_search = url_search + "&naam=" + URLEncoder.encode(orgnaam, "UTF-8");
                }
            }
            if (!orgplaats.isEmpty()) {
                if (isFirst) {
                    url_search = url_search + "?plaats=" + URLEncoder.encode(orgplaats, "UTF-8");
                    isFirst = false;
                } else {
                    url_search = url_search + "&plaats=" + URLEncoder.encode(orgplaats, "UTF-8");
                }
            }
            if (!orgkvk.isEmpty()) {
                if (isFirst) {
                    url_search = "?kvkNummer=" + URLEncoder.encode(orgkvk, "UTF-8");
                    isFirst = false;
                } else {
                    url_search = url_search + "&kvkNummer=" + URLEncoder.encode(orgkvk, "UTF-8");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OperationException((Throwable)e);
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("created url based on filters = " + url_search + "&resultatenPerPagina=" + aantal_resultaten));
        }
        HashMap<String, List<Object>> final_map = new HashMap<String, List<Object>>();
        HttpURLConnection con = null;
        ArrayList<String> kvknummer = new ArrayList<String>();
        ArrayList<String> adres = new ArrayList<String>();
        ArrayList<String> type = new ArrayList<String>();
        ArrayList<String> plaats = new ArrayList<String>();
        ArrayList<String> naam = new ArrayList<String>();
        ArrayList<String> vestigingsnummer = new ArrayList<String>();
        ArrayList<String> postcode = new ArrayList<String>();
        try {
            URL url = new URL(url_string + url_search);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("url called = " + url));
            }
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Cache-Control", "no-cache");
            con.setRequestProperty("User-Agent", "PostmanRuntime/7.26.2");
            con.setRequestProperty("Accept", "*/*");
            con.setRequestProperty("Connection", "keep-alive");
            con.setRequestProperty("Content-Type", "json");
            con.setRequestProperty("apikey", token);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(con.getInputStream());
            JsonNode service_answer = root.get("resultaten");
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("Resultaat: " + service_answer));
            }
            for (JsonNode orgs : service_answer) {
                if (orgs.get("kvkNummer") != null) {
                    kvknummer.add(orgs.get("kvkNummer").textValue());
                } else {
                    kvknummer.add("");
                }
                if (orgs.get("naam") != null) {
                    naam.add(orgs.get("naam").textValue());
                } else {
                    naam.add("");
                }
                if (orgs.get("vestigingsnummer") != null) {
                    vestigingsnummer.add(orgs.get("vestigingsnummer").textValue());
                } else {
                    vestigingsnummer.add("");
                }
                JsonNode adresTussen = orgs.get("adres");
                JsonNode adresNode = null;
                if (adresTussen != null && adresTussen.get("binnenlandsAdres") != null) {
                    adresNode = adresTussen.get("binnenlandsAdres");
                    if (adresNode == null) continue;
                    if (adresNode.get("type") != null) {
                        type.add(adresNode.get("type").textValue());
                    } else {
                        type.add("");
                    }
                    if (adresNode.get("straatnaam") != null) {
                        adres.add(adresNode.get("straatnaam").textValue());
                    } else {
                        adres.add("");
                    }
                    if (adresNode.get("plaats") != null) {
                        plaats.add(adresNode.get("plaats").textValue());
                    } else {
                        plaats.add("");
                    }
                    if (adresNode.get("postcode") != null) {
                        postcode.add(adresNode.get("postcode").textValue());
                        continue;
                    }
                    postcode.add("");
                    continue;
                }
                if (adresTussen != null && adresTussen.get("buitenlandsAdres") != null) {
                    adresNode = adresTussen.get("buitenlandsAdres");
                    if (adresNode == null) continue;
                    if (adresNode.get("type") != null) {
                        type.add(adresNode.get("type").textValue());
                    } else {
                        type.add("");
                    }
                    if (adresNode.get("straatHuisnummer") != null) {
                        adres.add(adresNode.get("straatHuisnummer").textValue());
                    } else {
                        adres.add("");
                    }
                    if (adresNode.get("postcodeWoonplaats") != null) {
                        plaats.add(adresNode.get("postcodeWoonplaats").textValue());
                    } else {
                        plaats.add("");
                    }
                    postcode.add("");
                    continue;
                }
                type.add("");
                adres.add("");
                plaats.add("");
                postcode.add("");
            }
            final_map.put("kvknummer", kvknummer);
            final_map.put("adres", adres);
            final_map.put("type", type);
            final_map.put("plaats", plaats);
            final_map.put("naam", naam);
            final_map.put("vestigingsnummer", vestigingsnummer);
            final_map.put("postcode", postcode);
        }
        catch (FileNotFoundException e) {
            try {
                int responseCode = con.getResponseCode();
                if (responseCode == 404) {
                    final_map.put("kvknummer", kvknummer);
                    final_map.put("adres", adres);
                    final_map.put("type", type);
                    final_map.put("plaats", plaats);
                    final_map.put("naam", naam);
                    final_map.put("vestigingsnummer", vestigingsnummer);
                    final_map.put("postcode", postcode);
                    return final_map;
                }
            }
            catch (IOException e1) {
                log4j.error((Object)"Error fetching data", (Throwable)e);
                throw new OperationException("Error fetching data", (Throwable)e);
            }
        }
        catch (Exception e) {
            log4j.error((Object)"Error fetching data", (Throwable)e);
            throw new OperationException("Error fetching data", (Throwable)e);
        }
        return final_map;
    }

    public String getDescription() {
        return "Get list of organisations based of search";
    }

    public Operator getOperator(String arg0) {
        return null;
    }

    public void setDataset(Dataset pDS) {
        this.iDataset = pDS;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String arg0, List<Object> arg1) {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public boolean supportsResultset() {
        return false;
    }
}

