/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import javax.activation.MimetypesFileTypeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.groenfonds.jobs.CheyenneLogin;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

@Entity
@Table(name="vp_document")
public class VpDocument
extends CheyenneLogin
implements Closeable {
    private static Logger log4j = Log4jUtil.createLogger();
    private InputStream iStream = null;
    private String sessionId = null;
    @Id
    @Column(name="doc_id")
    private Integer docId;
    @Column(name="org_id")
    private Integer orgId;
    @Column(name="proj_id")
    private Integer projId;
    @Column(name="fr_id")
    private Integer frId;
    @Column(name="docname")
    private String docName;
    @Column(name="docstore_loc")
    private String docstoreLocation;
    @Column(name="current_version_id")
    private Integer currentVersionId;

    public Integer getDocId() {
        return this.docId;
    }

    public void setDocId(Integer pDocId) {
        this.docId = pDocId;
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Integer pOrgId) {
        this.orgId = pOrgId;
    }

    public Integer getProjId() {
        return this.projId;
    }

    public void setProjId(Integer pProjId) {
        this.projId = pProjId;
    }

    public Integer getFrId() {
        return this.frId;
    }

    public void setFrId(Integer pFrId) {
        this.frId = pFrId;
    }

    public String getDocName() {
        return this.docName;
    }

    public void setDocName(String pDocName) {
        this.docName = pDocName;
    }

    public String getDocstoreLocation() {
        return this.docstoreLocation;
    }

    public void setDocstoreLocation(String pDocstoreLocation) {
        this.docstoreLocation = pDocstoreLocation;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String pSessionId) {
        this.sessionId = pSessionId;
    }

    public InputStream getFileStream() throws OperationException {
        if (this.iStream == null) {
            String lSessionId = this.sessionId;
            if (lSessionId == null) {
                this.httpLogin();
                lSessionId = VpDocument.getSession();
            }
            String contentUrl = ConfigurationProperties.get().get("LOCAL_BASE");
            String lDocstoreBase = ConfigurationProperties.get().get("DOCSTORE_BASE");
            contentUrl = contentUrl + "jsp/callDocstore.jsp;jsessionid=" + lSessionId + '?';
            if (this.docstoreLocation.endsWith(".fo")) {
                contentUrl = contentUrl + "xslfo=docx&";
            }
            try {
                contentUrl = contentUrl + "url=" + URLEncoder.encode(lDocstoreBase + this.docstoreLocation, "UTF-8") + '&';
                contentUrl = contentUrl + "mimeType=" + this.getContentType(null);
                contentUrl = contentUrl + "&P_DOC_ID=" + this.getDocId();
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Get doc for url " + contentUrl));
                }
                URL ldocLoc = new URL(contentUrl);
                this.iStream = ldocLoc.openStream();
            }
            catch (IOException e) {
                log4j.error((Object)"Could not get file", (Throwable)e);
                throw new OperationException((Throwable)e);
            }
        }
        return this.iStream;
    }

    public String getContentType(String pArg0) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getContentType called - pArg0=%1$s", pArg0));
        }
        String file = this.getDocName();
        String mime = null;
        if (file.endsWith("docx")) {
            mime = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        } else {
            MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
            mime = fileTypeMap.getContentType(file);
        }
        if (mime == null) {
            mime = "application/octet-stream";
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("file:" + file + " mime:" + mime));
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyDocumentResource.getContentType returns - value=%1$s", mime));
        }
        return mime;
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtil.close((Closeable)this.iStream);
            this.httpLogout();
        }
        catch (OperationException e) {
            log4j.error((Object)"Coud not close", (Throwable)e);
        }
    }

    public Integer getCurrentVersionId() {
        return this.currentVersionId;
    }

    public void setCurrentVersionId(Integer pCurrentVersionId) {
        this.currentVersionId = pCurrentVersionId;
    }

    public String toString() {
        StringBuilder lBuilder = new StringBuilder();
        lBuilder.append("VpDocument [iStream=").append(this.iStream).append(", sessionId=").append(this.sessionId).append(", docId=").append(this.docId).append(", orgId=").append(this.orgId).append(", projId=").append(this.projId).append(", frId=").append(this.frId).append(", docName=").append(this.docName).append(", docstoreLocation=").append(this.docstoreLocation).append(", currentVersionId=").append(this.currentVersionId).append("]");
        return lBuilder.toString();
    }
}

