package nl.buildersenperformers.cheyenne.configtest;

import java.io.File;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.ErrorHandler;

import nl.knowledgeplaza.util.ConfigurationProperties;

public class ConfigTest {
	
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	public static void main(String[] args) {
		log4j.getLoggerRepository().addHierarchyEventListener(new Log4jCounter());
		
		//Parse arguments
		if (args.length!=2){
			System.out.println("Usage: ConfigTest <path to config> <path to webapp root");
			return;
		}
		
		//get config file
		String lSettings=args[0];
		File lConfigFile=new File(lSettings);
		
		if (!lConfigFile.exists()){
			log4j.error("Config file " + lSettings + " does not exists");
			return;
		}
		log4j.info("Config file: " + lSettings);
		
		//get webapp root
		String lWebappRoot=args[1];
		File lWebappRootFile=new File(lWebappRoot);
		if (!lWebappRootFile.exists()){
			log4j.error("Webapp root " + lWebappRoot + " does not exists");
			return;
		}
		
		log4j.info("Webapp root: " + lWebappRoot);
		
		//Set config
		File[] lConfigFiles={lConfigFile};
		ConfigurationProperties lConfig = new ConfigurationProperties(lConfigFiles);
		ConfigurationProperties.set(lConfig);
		
		int errorCount=0;
		
		//Test database
		log4j.info("------------------------ Testing database connection ------------------------");
		errorCount += new DbTests().testConnection();
		
		//Test file locations
		log4j.info("------------------------ Testing file locations ------------------------");
		errorCount += new FileLocations().test(lWebappRoot);
		
		//test docstore
		log4j.info("------------------------ Testing docstore ------------------------");
		errorCount += new DocstoreTest().test();
		
		
		//check the security filter
		log4j.info("------------------------ Testing security filter ------------------------");
		errorCount += new SecurityFilterTest().test(lWebappRoot);
		
		//Test https connections
		log4j.info("------------------------ Testing https connections ------------------------");
		errorCount += new HttpsTest().test();
		
		log4j.info("------------------------ Testing finished ------------------------");
		log4j.info("Number of errors: " + errorCount);

	}

}
