package nl.buildersenperformers.cheyenne.configtest;
import java.io.File;

import org.apache.log4j.Logger;

import nl.knowledgeplaza.util.ConfigurationProperties;

public class FileLocations {
	Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	/**
	 * Test the file locations
	 */
	public int test(String pWebappRoot){ 
		int errorCount=0;
		errorCount+=testPropertyPath("dataset.configBase");
		errorCount+=testPropertyPath("DD_TEXT_FILE_PATH");
		errorCount+=testPropertyPath("LAYOUTPATH");
		errorCount+=testPropertyPath("LETTERPATH");
		errorCount+=testPropertyPath("nl.knowledgeplaza.filters.XsltfoFilter.FopConfigFile");
		errorCount+=testPropertyPath("aspose.fontDirectory");
		errorCount+=testPropertyPath("ca.cert");
		errorCount+=testPropertyPath("ca.key");
		
		//check the dialog package property
		String lDialogPackage=ConfigurationProperties.get().get("CheyenneServlet.DialogPackage").toString();
		log4j.info("Dialog package path (CheyenneServlet.DialogPackage): " + lDialogPackage);
		File lDialogPackageFile=new File(pWebappRoot + "/WEB-INF/classes/" + lDialogPackage.replace(".", "/"));
		if (!lDialogPackageFile.exists()){
			log4j.error("Dialog package path (CheyenneServlet.DialogPackage) " + lDialogPackageFile + " does not exists");
			errorCount++;
		} else {
			log4j.info("Dialog package path (CheyenneServlet.DialogPackage) exists: " + lDialogPackageFile);
		}
		return errorCount;
	}
	
	/**
	 * Test a property path 
	 * @param pProperty
	 */
	private int testPropertyPath(String pProperty) {
		int errorCount=0;
		String lDDTextFilePath=ConfigurationProperties.get().get(pProperty);
		if(lDDTextFilePath==null){
			return 0;
		}
		File lDDTextFilePathFile=new File(lDDTextFilePath.toString());
		if (!lDDTextFilePathFile.exists()){
			log4j.error(pProperty + ": " + lDDTextFilePath + " does not exists");
			errorCount++;
		} else {
			log4j.info(pProperty + ": " + lDDTextFilePath + " exists");
		}
		return errorCount;
	}

}
