package nl.buildersenperformers.cheyenne.configtest;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

import org.apache.log4j.Logger;

import nl.knowledgeplaza.util.ConfigurationProperties;

public class HttpsTest {
	Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();
	
	public int test() {
		int errorCount=0;
		//List all https url's from config
		for(Object props:ConfigurationProperties.get().getProperties().keySet()){
			//If prop is String and value starts with https then check connection
			if(props instanceof String && ConfigurationProperties.get().get((String)props).startsWith("https")){
				String url=ConfigurationProperties.get().get((String)props);
				if(!sslPoke((String)props,url)){
					log4j.error("SSL connection failed to " + url);
					errorCount++;
				} else {
					log4j.info("SSL connection ok to " + url);
				}
			}
		} 
		
		return errorCount;
	}
	
	/**
	 * Check ssl connection
	 * @param url
	 */
	private boolean sslPoke(String prop, String pUrl) {
		
		try {
			URL url = new URL(pUrl);
			int port=url.getPort();
			if(port==-1){
				port=443;
			}
			
			log4j.info(prop + ": Testing SSL connection to " + url.getHost() + ":" + port);
			
			SSLSocketFactory factory = (SSLSocketFactory) SSLSocketFactory.getDefault();
			SSLSocket sslsocket = (SSLSocket) factory.createSocket(url.getHost(), port);
	
			InputStream in = sslsocket.getInputStream();
			OutputStream out = sslsocket.getOutputStream();
	
			// Write a test byte to get a reaction :)
			out.write(1);
	
			while (in.available() > 0) {
				System.out.print(in.read());
			}
		} catch (Exception e) {
			log4j.error(prop + ": SSL connection failed to: " + pUrl,e);
			return false;
		}
		return true;
	}

}
