package nl.buildersenperformers.cheyenne.configtest;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import nl.knowledgeplaza.util.ConfigurationProperties;

public class SecurityFilterTest {
	Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	public int test(String webappRoot) {
		int errorCount = 0;
		//get the security filter from the web.xml file
		File webXmlFile=new File(webappRoot + "/WEB-INF/web.xml");
		if (!webXmlFile.exists()){
			log4j.error("Web xml file " + webXmlFile + " does not exists");
			return 1;
		}
		
		//parse xml file
		String lSecurityFilter=getSecurityFilter(webXmlFile);
		if (lSecurityFilter==null){
			log4j.error("Security filter not found");
			return 1;
		}
		log4j.info("Security filter: " + lSecurityFilter);
		
		//check if login page exists
		String loginPageFileProp=ConfigurationProperties.get().get(lSecurityFilter + ".LoginPage");
		log4j.info("LoginPage: " + webappRoot + loginPageFileProp);
		File loginPageFile=new File(webappRoot + loginPageFileProp);
		if (!loginPageFile.exists()){
			log4j.error("Login page file " + loginPageFile + " does not exists");
			errorCount++;
		} else {
			log4j.info("Login page file exists");
		}
		
		//test security filter pool
		String securityFilterPoolProp=lSecurityFilter + ".JdbcPoolName";
		log4j.info("Security filter pool property: " + securityFilterPoolProp);
		errorCount+= new DbTests().testPool(securityFilterPoolProp);
		return errorCount;
	}

	private String getSecurityFilter(File webXmlFile) {
		//parse web.xml
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(webXmlFile);
			NodeList nl = doc.getElementsByTagName("filter");
			for (int i = 0; i < nl.getLength(); i++) {
				Node n = nl.item(i);
				if (n.getNodeName().equals("filter")) {
					NodeList nl2 = n.getChildNodes();
					for (int j = 0; j < nl2.getLength(); j++) {
						Node n2 = nl2.item(j);
						if (n2.getNodeName().equals("filter-name")) {
							if(n2.getTextContent().equals("KPSecurityFilter")){
								Element e = (Element) n;
								return e.getElementsByTagName("filter-class").item(0).getTextContent();
							}
						}
					}
				}
			}
		} catch (Exception e) {
			log4j.error("Error parsing web.xml",e);
		}
		return null;
	}

	

}
