package nl.buildersenperformers.cheyenne.dialog.dataset;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import org.apache.log4j.Logger;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DialogOperation;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.servlet.CheyenneServletContext;
import nl.innovationinvestments.cheyenne.engine.servlet.Context;
import nl.knowledgeplaza.util.Base64;
import nl.knowledgeplaza.util.Properties;

public class RequestStringOperation implements Operation, DialogOperation {
	public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(RequestStringOperation.class);
	
	private Dialog iDialog=null;
	private Dataset iDataset;
	private Map<String,Object> iParams;
	private Properties iProperties;
	private String iId;
	private String iCtx;
	
	List<String> iIgnoredParams;
	
	public RequestStringOperation() {
		iParams=new HashMap<>();
		iIgnoredParams=new ArrayList<>();
		iIgnoredParams.add("request.preventCache");
		iIgnoredParams.add("contenttype");
	}

	@Override
	public void setDialog(Dialog pDialog) {
		iDialog = pDialog;
	}

	@Override
	public Dialog getDialog() {
		return iDialog;
	}

	@Override
	public Operator getOperator(String pName) {
		return null;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		//if parameter name is ignore than add the value to the ignored params
		if(pName.startsWith("ignore")){
			iIgnoredParams.add((String)pValue);
			return;
		} else if(pName.equals("ctx")){
			iCtx=(String)pValue;
			return;
		}
		
		iParams.put(pName, pValue);
	}

	@Override
	public void setParameter(String pName, List<Object> pValue) {
		/* nothing for now*/
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean supportsResultset() {
		return false;
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		Map<String,List<Object>> result=new HashMap<>();
		
		//Get context from dialog if dialog is set 
		if(iDialog!=null){
			Context chyContext=(Context)iDialog.getContext();
			CheyenneServletContext context=new CheyenneServletContext(chyContext);
			if(iCtx!=null){
				buildFromCtxParams(result);
			} else {
				buildFromRequest(result, context);
			}
			
		}
		return result;
	}

	private void buildFromCtxParams(Map<String, List<Object>> result) {
		StringJoiner queryBuilder=new StringJoiner("&");
		
		//get the json string from the iCtx variable. The signature is allready check by the CheyenneServlet
		String[] contextParts = iCtx.split("\\:");
		
		byte[] contextBytes=Base64.decode(contextParts[0]);
		String contextString=new String(contextBytes);
		JSON json = JSONSerializer.toJSON(contextString);
		if (json instanceof JSONObject) {
			JSONObject jsonObj = (JSONObject)json;
			Iterator<String> keys = jsonObj.keys();
			while(keys.hasNext()){
				String key = keys.next();

				//if paremeter name is in the ignore list than skip
				if(iIgnoredParams.contains(key)){
					continue;
				}
				
				JSONArray values=jsonObj.getJSONArray(key);
				
				for (int i = 0; i < values.size(); i++) {
					String parameterValue = values.getString(i);
					try {
						queryBuilder.add(key+"="+ URLEncoder.encode(parameterValue, "UTF-8"));
					} catch (UnsupportedEncodingException e) {
						queryBuilder.add(key+"="+ parameterValue);
					}
				}
				
			}
			
		}
		//create the result
		String fieldName="query";
		if(getId()!=null){
			fieldName=getId() + "_" + fieldName;
		}
		List<Object> lFieldValue=new ArrayList<>();
		lFieldValue.add(queryBuilder.toString());
		result.put(fieldName, lFieldValue);
		
		
	}

	private void buildFromRequest(Map<String, List<Object>> result, CheyenneServletContext context) {
		if(context!=null){
			//Build the query string from the request
			Enumeration<String> parameterNames = context.getRequest().getParameterNames();
			StringJoiner queryBuilder=new StringJoiner("&");
			while(parameterNames.hasMoreElements()){
				String parameterName=parameterNames.nextElement();
				
				//if paremeter name is in the ignore list than skip
				if(iIgnoredParams.contains(parameterName)){
					continue;
				}
				
				String[] parameterValues = context.getRequest().getParameterValues(parameterName);
				
				for(String parameterValue:parameterValues){
					try {
						queryBuilder.add(parameterName+"="+ URLEncoder.encode(parameterValue, "UTF-8"));
					} catch (UnsupportedEncodingException e) {
						queryBuilder.add(parameterName+"="+ parameterValue);
					}
				}
			}
			
			//create the result
			String fieldName="query";
			if(getId()!=null){
				fieldName=getId() + "_" + fieldName;
			}
			List<Object> lFieldValue=new ArrayList<>();
			lFieldValue.add(queryBuilder.toString());
			result.put(fieldName, lFieldValue);
		}
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		return null;
	}

	@Override
	public void close() {
		/* nothing for now*/

	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;
	}

	@Override
	public void setDataset(Dataset pDataset) {
		iDataset=pDataset;

	}

	@Override
	public String getDescription() {
		return "RequestString";
	}

	@Override
	public void setId(String pId) {
		iId=pId;
	}

	@Override
	public String getId() {
		return iId;
	}

}
