/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.common.Path;
import io.milton.http.exceptions.BadRequestException;
import io.milton.servlet.MiltonServlet;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.buildersenperformers.cheyenne.dav.ChyAuthorisation;
import nl.buildersenperformers.cheyenne.util.CheyenneServerContent;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ChyAbstractResource {
    static Logger log4j = Logger.getLogger((String)ChyAuthorisation.class.getName());
    protected Path iPath = null;

    public Path getPath() {
        return this.iPath;
    }

    public void setPath(Path pPath) {
        this.iPath = pPath;
    }

    protected int rename(String newName) throws BadRequestException {
        return this.rename(newName, null);
    }

    protected int rename(String newName, String pUserUrl) throws BadRequestException {
        Principal prin;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAbstractResource.rename called - newName=%1$s", newName));
        }
        int lResult = -1;
        String lUserUrl = "";
        if (pUserUrl != null) {
            lUserUrl = "&" + pUserUrl;
        }
        if ((prin = MiltonServlet.request().getUserPrincipal()) == null) {
            return -1;
        }
        lUserUrl = String.valueOf(lUserUrl) + "&cusername=" + prin.getName();
        try {
            CheyenneServerContent lChyRename = new CheyenneServerContent(MiltonServlet.request(), "cddid=documents.dav_rename&cmode=xml&P_PATH=" + URLEncoder.encode(this.getPath().toString(), "UTF-8") + "&P_NEW_NAME=" + URLEncoder.encode(newName, "UTF-8").replace("+", "%20") + lUserUrl, "text/xml");
            if (!lChyRename.isOk()) {
                throw new BadRequestException("Could not rename document. Error:" + lChyRename.getContent());
            }
            lResult = this.getResultFromResponse(lChyRename.getContent());
        }
        catch (UnsupportedEncodingException e) {
            throw new BadRequestException("Could not rename document. encodeing error", (Throwable)e);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAbstractResource.rename returns result=" + lResult, new Object[0]));
        }
        return lResult;
    }

    protected int dav_delete() throws BadRequestException {
        return this.dav_delete(null);
    }

    protected int dav_delete(String pUserUrl) throws BadRequestException {
        Principal prin;
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAbstractResource.dav_delete called", new Object[0]));
        }
        int lResult = -1;
        String lUserUrl = "";
        if (pUserUrl != null) {
            lUserUrl = "&" + pUserUrl;
        }
        if ((prin = MiltonServlet.request().getUserPrincipal()) == null) {
            return -1;
        }
        lUserUrl = String.valueOf(lUserUrl) + "&cusername=" + prin.getName();
        try {
            CheyenneServerContent lChyRename = new CheyenneServerContent(MiltonServlet.request(), "cddid=documents.dav_delete&cmode=xml&P_PATH=" + URLEncoder.encode(this.getPath().toString(), "UTF-8") + lUserUrl, "text/xml");
            if (!lChyRename.isOk()) {
                throw new BadRequestException("Could not delete document. Error:" + lChyRename.getContent());
            }
            lResult = this.getResultFromResponse(lChyRename.getContent());
        }
        catch (UnsupportedEncodingException e) {
            throw new BadRequestException("Could not delete document. encodeing error", (Throwable)e);
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAbstractResource.rename dav_delete result=" + lResult, new Object[0]));
        }
        return lResult;
    }

    private int getResultFromResponse(String pResponse) {
        int lResult = 0;
        SAXParserFactory iSaxFactory = null;
        iSaxFactory = SAXParserFactory.newInstance();
        iSaxFactory.setXIncludeAware(true);
        iSaxFactory.setNamespaceAware(true);
        try {
            SAXParser parser = iSaxFactory.newSAXParser();
            SAXReader reader = new SAXReader(parser.getXMLReader());
            reader.setStripWhitespaceText(true);
            reader.setMergeAdjacentText(true);
            reader.setIgnoreComments(true);
            Document document = DocumentHelper.parseText((String)pResponse);
            Element lRootNode = document.getRootElement();
            lRootNode = lRootNode.element("diag");
            Element lResultNode = lRootNode.element("result");
            lResult = Integer.parseInt(lResultNode.getTextTrim());
        }
        catch (DocumentException e) {
            log4j.warn((Object)e);
            return -1;
        }
        catch (ParserConfigurationException e) {
            log4j.warn((Object)e);
            return -1;
        }
        catch (SAXException e) {
            log4j.warn((Object)e);
            return -1;
        }
        return lResult;
    }
}

