/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.values.HrefList;
import io.milton.principal.Principal;
import io.milton.resource.AccessControlledResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.cheyenne.dav.ChyAbstractResource;
import nl.knowledgeplaza.util.ConfigurationProperties;
import org.apache.log4j.Logger;

public class ChyAuthorisation
extends ChyAbstractResource
implements AccessControlledResource {
    public static final String SOURCECODE_VERSION = "$Revision: 1.3 $";
    static Logger log4j = Logger.getLogger((String)ChyAuthorisation.class.getName());
    static String iConfigName = "webdav.auth.";
    protected boolean iAuthCreate = false;
    protected boolean iAuthRead = false;
    protected boolean iAuthUpdate = false;
    protected boolean iAuthDelete = false;
    private ConfigurationProperties iConfigurationProperties = null;
    private Map<Request.Method, Map<String, Boolean>> iMethods = null;

    public ChyAuthorisation() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation constructor called", new Object[0]));
        }
        this.iConfigurationProperties = ConfigurationProperties.get();
        this.iMethods = new HashMap<Request.Method, Map<String, Boolean>>();
        this.readConfig();
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation constructor returns", new Object[0]));
        }
    }

    private void readConfig() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.readConfig called", new Object[0]));
        }
        Request.Method[] methodArray = Request.Method.values();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Request.Method lMethod = methodArray[n2];
            String lMask = this.iConfigurationProperties.get(String.valueOf(iConfigName) + lMethod);
            if (lMask != null) {
                HashMap<String, Boolean> lAuth = new HashMap<String, Boolean>();
                ACRUD[] aCRUDArray = ACRUD.values();
                int n3 = aCRUDArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ACRUD lCrud = aCRUDArray[n4];
                    if (log4j.isDebugEnabled() && lMask.contains(lCrud.toString())) {
                        log4j.debug((Object)("Adding method: " + lMethod + " for " + (Object)((Object)lCrud)));
                    }
                    lAuth.put(lCrud.toString(), lMask.contains(lCrud.toString()));
                    ++n4;
                }
                this.iMethods.put(lMethod, lAuth);
            }
            ++n2;
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.readConfig returns", new Object[0]));
        }
    }

    protected boolean isAuthenticated(Request.Method pMethod) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated called - method=%1$s", pMethod));
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Authorizing method " + pMethod.toString()));
            log4j.debug((Object)("Create: " + this.isAuthCreate()));
            log4j.debug((Object)("Read: " + this.isAuthRead()));
            log4j.debug((Object)("Update: " + this.isAuthUpdate()));
            log4j.debug((Object)("Delete: " + this.isAuthDelete()));
        }
        boolean lResult = false;
        Map<String, Boolean> lMethod = this.iMethods.get(pMethod);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Method: " + lMethod));
        }
        if (lMethod == null) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"No method found");
            }
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated returns - value=false", new Object[0]));
            }
            return false;
        }
        if (lMethod.get("A").booleanValue() && lMethod.get("A").booleanValue()) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Allways authorized");
            }
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated returns - value=true", new Object[0]));
            }
            return true;
        }
        if (lMethod.get("C").booleanValue() && this.isAuthCreate()) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Autorized for create");
            }
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated returns - value=true", new Object[0]));
            }
            return true;
        }
        if (lMethod.get("R").booleanValue() && this.isAuthRead()) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Autorized for read");
            }
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated returns - value=true", new Object[0]));
            }
            return true;
        }
        if (lMethod.get("U").booleanValue() && this.isAuthUpdate()) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Autorized for update");
            }
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated returns - value=true", new Object[0]));
            }
            return true;
        }
        if (lMethod.get("D").booleanValue() && this.isAuthDelete()) {
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"Autorized for delete");
            }
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated returns - value=true", new Object[0]));
            }
            return true;
        }
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)"Not Autorized");
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.isAuthenticated returns - value=%1$s", lResult));
        }
        return lResult;
    }

    public boolean isAuthCreate() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.isAuthCreate getter - value=%1$s", this.iAuthCreate));
        }
        return this.iAuthCreate;
    }

    public void setAuthCreate(boolean pAuthCreate) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.setAuthCreate setter - value=%1$s", pAuthCreate));
        }
        this.iAuthCreate = pAuthCreate;
    }

    public boolean isAuthRead() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.isAuthRead getter - value=%1$s", this.iAuthRead));
        }
        return this.iAuthRead;
    }

    public void setAuthRead(boolean pAuthRead) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.setAuthRead setter - value=%1$s", pAuthRead));
        }
        this.iAuthRead = pAuthRead;
    }

    public boolean isAuthUpdate() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.isAuthUpdate getter - value=%1$s", this.iAuthUpdate));
        }
        return this.iAuthUpdate;
    }

    public void setAuthUpdate(boolean pAuthUpdate) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.setAuthUpdate setter - value=%1$s", pAuthUpdate));
        }
        this.iAuthUpdate = pAuthUpdate;
    }

    public boolean isAuthDelete() {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.isAuthDelete getter - value=%1$s", this.iAuthDelete));
        }
        return this.iAuthDelete;
    }

    public void setAuthDelete(boolean pAuthDelete) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.setAuthDelete setter - value=%1$s", pAuthDelete));
        }
        this.iAuthDelete = pAuthDelete;
    }

    public Map<Principal, List<AccessControlledResource.Priviledge>> getAccessControlList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<AccessControlledResource.Priviledge> getPriviledges(Auth auth) {
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.getPriviledges called auth=%1$s", auth));
        }
        ArrayList<AccessControlledResource.Priviledge> priviledgesList = new ArrayList<AccessControlledResource.Priviledge>();
        if (this.isAuthCreate()) {
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_ACL);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_CONTENT);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_PROPERTIES);
            priviledgesList.add(AccessControlledResource.Priviledge.UNLOCK);
        }
        if (this.isAuthRead()) {
            priviledgesList.add(AccessControlledResource.Priviledge.READ);
            priviledgesList.add(AccessControlledResource.Priviledge.READ_ACL);
            priviledgesList.add(AccessControlledResource.Priviledge.READ_CONTENT);
            priviledgesList.add(AccessControlledResource.Priviledge.READ_PROPERTIES);
        }
        if (this.isAuthUpdate()) {
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_ACL);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_CONTENT);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_PROPERTIES);
            priviledgesList.add(AccessControlledResource.Priviledge.UNLOCK);
        }
        if (this.isAuthDelete()) {
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_ACL);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_CONTENT);
            priviledgesList.add(AccessControlledResource.Priviledge.WRITE_PROPERTIES);
            priviledgesList.add(AccessControlledResource.Priviledge.UNLOCK);
        }
        log4j.info((Object)"getPriviledges returned");
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyAuthorisation.getPrivileges returns - value=%1$s", priviledgesList));
        }
        return priviledgesList;
    }

    public void setAccessControlList(Map<Principal, List<AccessControlledResource.Priviledge>> privs) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getPrincipalURL() {
        return null;
    }

    public String getUniqueId() {
        return null;
    }

    public String getName() {
        return null;
    }

    public Object authenticate(String user, String password) {
        return null;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return false;
    }

    public String getRealm() {
        return null;
    }

    public Date getModifiedDate() {
        return null;
    }

    public String checkRedirect(Request request) throws NotAuthorizedException, BadRequestException {
        return null;
    }

    public HrefList getPrincipalCollectionHrefs() {
        return null;
    }

    private static enum ACRUD {
        A,
        C,
        R,
        U,
        D;

    }
}

