/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.dav;

import io.milton.common.Path;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import io.milton.servlet.MiltonServlet;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.buildersenperformers.cheyenne.dav.ChyDocumentResource;
import nl.buildersenperformers.cheyenne.dav.ChyFolderResource;
import nl.buildersenperformers.cheyenne.dav.ChyReadmeResource;
import nl.buildersenperformers.cheyenne.dav.DesktopIniResource;
import nl.buildersenperformers.cheyenne.util.CheyenneServerContent;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ChyResourceBuilder {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.12 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private SAXParserFactory iSaxFactory = SAXParserFactory.newInstance();
    private CheyenneServerContent chyContent = null;
    private String iReadmePath = null;

    public ChyResourceBuilder() {
        this.iSaxFactory.setXIncludeAware(true);
        this.iSaxFactory.setNamespaceAware(true);
        this.iReadmePath = ConfigurationProperties.get().get("webdav.readme");
        log4j.info((Object)("Readme path=" + this.iReadmePath));
    }

    public Resource build(Path uri) throws NotAuthorizedException, BadRequestException {
        return this.build(uri, null);
    }

    public Resource build(Path uri, String extra) throws NotAuthorizedException, BadRequestException {
        ChyFolderResource iRetVal;
        block32: {
            if (log4j.isInfoEnabled()) {
                log4j.info((Object)String.format("ChyResourceBuilder.build called - uri=%1$s, extra=%2$s", uri, extra));
            }
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            formatter.setTimeZone(TimeZone.getTimeZone("Europe/Amsterdam"));
            Date now = new Date();
            iRetVal = null;
            ChyReadmeResource lReadmeUri = this.getReadmeResource(uri);
            if (lReadmeUri != null) {
                return lReadmeUri;
            }
            try {
                Path contentURI = uri;
                if (uri.toString().endsWith("/desktop.ini")) {
                    contentURI = uri.getParent();
                }
                if (contentURI.toString().isEmpty()) {
                    contentURI = Path.path((String)"/");
                }
                this.chyContent = new CheyenneServerContent(MiltonServlet.request(), "cddid=documents.dav&cmode=xml&path=" + URLEncoder.encode(contentURI.toString(), "UTF-8") + "&contenttype=text/xml" + (extra != null ? extra : ""), "text/xml");
                String content = this.chyContent.getContent();
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)("Get content from: cddid=documents.dav&cmode=xml&path=" + URLEncoder.encode(contentURI.toString(), "UTF-8") + "&contenttype=text/xml" + (extra != null ? extra : "")));
                }
                SAXParser parser = this.iSaxFactory.newSAXParser();
                SAXReader reader = new SAXReader(parser.getXMLReader());
                reader.setStripWhitespaceText(true);
                reader.setMergeAdjacentText(true);
                reader.setIgnoreComments(true);
                Document document = DocumentHelper.parseText((String)content);
                Element lRootNode = document.getRootElement();
                lRootNode = lRootNode.element("diag");
                if (uri.toString().endsWith("/desktop.ini")) {
                    lRootNode = (Element)lRootNode.elements().get(0);
                    String created = lRootNode.attributeValue("created");
                    String modified = lRootNode.attributeValue("modified");
                    String name = lRootNode.attributeValue("name");
                    String authCreate = lRootNode.attributeValue("auth_create");
                    String authRead = lRootNode.attributeValue("auth_read");
                    String authUpdate = lRootNode.attributeValue("auth_update");
                    String authDelete = lRootNode.attributeValue("auth_delete");
                    if (lRootNode.getName() == "folder") {
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)"Constructing DesktopIniResource");
                        }
                        DesktopIniResource lChild = new DesktopIniResource();
                        lChild.setDateModified(modified == null || modified.equals("") ? now : formatter.parse(modified));
                        lChild.setDateCreated(modified == null || created.equals("") ? now : formatter.parse(created));
                        lChild.setParentName(contentURI.getName());
                        lChild.setAuthCreate(authCreate != null && authCreate.equals("1"));
                        lChild.setAuthRead(authRead != null && authRead.equals("1"));
                        lChild.setAuthUpdate(authUpdate != null && authUpdate.equals("1"));
                        lChild.setAuthDelete(authDelete != null && authDelete.equals("1"));
                        if (log4j.isInfoEnabled()) {
                            log4j.info((Object)String.format("ChyResourceBuilder.build returns - value=%1$s", lChild));
                        }
                        return lChild;
                    }
                    break block32;
                }
                if (lRootNode.elements().size() <= 0) break block32;
                lRootNode = (Element)lRootNode.elements().get(0);
                String created = lRootNode.attributeValue("created");
                String modified = lRootNode.attributeValue("modified");
                String name = lRootNode.attributeValue("name");
                String authCreate = lRootNode.attributeValue("auth_create");
                String authRead = lRootNode.attributeValue("auth_read");
                String authUpdate = lRootNode.attributeValue("auth_update");
                String authDelete = lRootNode.attributeValue("auth_delete");
                if (lRootNode.getName() == "folder") {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)"Constructing ChyFolderResource");
                    }
                    ChyFolderResource lFolder = new ChyFolderResource();
                    lFolder.setName(name);
                    lFolder.setModifiedDate(modified == null || modified.equals("") ? now : formatter.parse(modified));
                    lFolder.setCreateDate(modified == null || created.equals("") ? now : formatter.parse(created));
                    lFolder.setResBuilder(this);
                    lFolder.setPath(uri);
                    lFolder.setAuthCreate(authCreate != null && authCreate.equals("1"));
                    lFolder.setAuthRead(authRead != null && authRead.equals("1"));
                    lFolder.setAuthUpdate(authUpdate != null && authUpdate.equals("1"));
                    lFolder.setAuthDelete(authDelete != null && authDelete.equals("1"));
                    int i = 0;
                    int size = lRootNode.nodeCount();
                    while (i < size) {
                        Node node = lRootNode.node(i);
                        if (node instanceof Element) {
                            Element lENode = (Element)node;
                            created = lENode.attributeValue("created");
                            modified = lENode.attributeValue("modified");
                            authCreate = lENode.attributeValue("auth_create");
                            authRead = lENode.attributeValue("auth_read");
                            authUpdate = lENode.attributeValue("auth_update");
                            authDelete = lENode.attributeValue("auth_delete");
                            String lChildName = lENode.attributeValue("name");
                            if (log4j.isDebugEnabled()) {
                                log4j.debug((Object)("Got resource " + lChildName));
                            }
                            if (lENode.getName() == "folder") {
                                ChyFolderResource lChild = new ChyFolderResource();
                                lChild.setName(lChildName);
                                lChild.setModifiedDate(modified == null || modified.equals("") ? now : formatter.parse(modified));
                                lChild.setCreateDate(modified == null || created.equals("") ? now : formatter.parse(created));
                                lChild.setResBuilder(this);
                                lChild.setPath(Path.path((Path)uri, (String)lChildName));
                                lChild.setAuthCreate(authCreate != null && authCreate.equals("1"));
                                lChild.setAuthRead(authRead != null && authRead.equals("1"));
                                lChild.setAuthUpdate(authUpdate != null && authUpdate.equals("1"));
                                lChild.setAuthDelete(authDelete != null && authDelete.equals("1"));
                                if (lChild.isAuthCreate() || lChild.isAuthRead() || lChild.isAuthUpdate() || lChild.isAuthDelete()) {
                                    lFolder.addChilds((Resource)lChild);
                                }
                            } else {
                                ChyReadmeResource lReadme = this.getReadmeResource(Path.path((Path)uri, (String)lChildName));
                                if (lReadme != null) {
                                    lFolder.addChilds((Resource)lReadme);
                                } else {
                                    String lDocStore = lENode.attributeValue("url");
                                    ChyDocumentResource lChild = new ChyDocumentResource(lChildName, lDocStore, this.chyContent);
                                    lChild.setModifiedDate(modified == null || modified.equals("") ? now : formatter.parse(modified));
                                    lChild.setCreateDate(modified == null || created.equals("") ? now : formatter.parse(created));
                                    lChild.setResBuilder(this);
                                    lChild.setPath(Path.path((Path)uri, (String)lChildName));
                                    lChild.setDocStoreLocNew(lENode.attributeValue("new_version_url"));
                                    lChild.setDocId(lENode.attributeValue("doc_id"));
                                    String lLock = lENode.attributeValue("locked");
                                    String lSize = lENode.attributeValue("size");
                                    if (lSize != null && !lSize.isEmpty()) {
                                        lChild.setContentLength(new Long(lSize));
                                    }
                                    lChild.setLocked(lLock != null && lLock.equalsIgnoreCase("true"));
                                    lChild.setAuthCreate(authCreate != null && authCreate.equals("1"));
                                    lChild.setAuthRead(authRead != null && authRead.equals("1"));
                                    lChild.setAuthUpdate(authUpdate != null && authUpdate.equals("1"));
                                    lChild.setAuthDelete(authDelete != null && authDelete.equals("1"));
                                    if (lChild.isAuthCreate() || lChild.isAuthRead() || lChild.isAuthUpdate() || lChild.isAuthDelete()) {
                                        lFolder.addChilds((Resource)lChild);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    iRetVal = lFolder;
                    break block32;
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"Constructing ChyDocumentResource");
                }
                String lDocStore = lRootNode.attributeValue("url");
                ChyDocumentResource lChild = new ChyDocumentResource(name, lDocStore, this.chyContent);
                lChild.setModifiedDate(modified == null || modified.equals("") ? now : formatter.parse(modified));
                lChild.setCreateDate(modified == null || created.equals("") ? now : formatter.parse(created));
                lChild.setResBuilder(this);
                lChild.setPath(Path.path((Path)uri, (String)name));
                lChild.setDocStoreLocNew(lRootNode.attributeValue("new_version_url"));
                lChild.setDocId(lRootNode.attributeValue("doc_id"));
                String lLock = lRootNode.attributeValue("locked");
                lChild.setLocked(lLock != null && lLock.equalsIgnoreCase("true"));
                String lSize = lRootNode.attributeValue("size");
                if (lSize != null && !lSize.isEmpty()) {
                    lChild.setContentLength(new Long(lSize));
                }
                lChild.setAuthCreate(authCreate != null && authCreate.equals("1"));
                lChild.setAuthRead(authRead != null && authRead.equals("1"));
                lChild.setAuthUpdate(authUpdate != null && authUpdate.equals("1"));
                lChild.setAuthDelete(authDelete != null && authDelete.equals("1"));
                if (log4j.isInfoEnabled()) {
                    log4j.info((Object)String.format("ChyResourceBuilder.build returns - value=%1$s", lChild));
                }
                return lChild;
            }
            catch (UnsupportedEncodingException e) {
                log4j.error((Object)e);
                throw new BadRequestException("Could not get content from server", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                log4j.error((Object)e);
                throw new BadRequestException("Could not get content from server", (Throwable)e);
            }
            catch (SAXException e) {
                log4j.error((Object)e);
                throw new BadRequestException("Could not get content from server", (Throwable)e);
            }
            catch (DocumentException e) {
                log4j.error((Object)e);
                throw new BadRequestException("Could not get content from server", (Throwable)e);
            }
            catch (ParseException e) {
                log4j.error((Object)e);
                throw new BadRequestException("Could not get content from server", (Throwable)e);
            }
            catch (Exception e) {
                log4j.error((Object)e);
                throw new BadRequestException("Could not get content from server", (Throwable)e);
            }
        }
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)String.format("ChyResourceBuilder.build returns - value=%1$s", iRetVal));
        }
        return iRetVal;
    }

    public String getSessionID() {
        if (this.chyContent != null) {
            return this.chyContent.iSessionID;
        }
        return null;
    }

    private ChyReadmeResource getReadmeResource(Path pPath) {
        ChyReadmeResource lRes = null;
        this.iReadmePath = ConfigurationProperties.get().get("webdav.readme");
        log4j.info((Object)("Readme path=" + this.iReadmePath));
        String lReadmeFilename = pPath.getName();
        if (lReadmeFilename == null) {
            return null;
        }
        File lReadmeFile = new File(this.iReadmePath, lReadmeFilename);
        log4j.info((Object)("Detecting readme file for path: " + lReadmeFile.getAbsolutePath()));
        if (!lReadmeFile.exists()) {
            return null;
        }
        lRes = new ChyReadmeResource(lReadmeFile);
        lRes.setAuthRead(true);
        return lRes;
    }
}

