/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.cheyenne.util;

import java.io.File;
import java.io.IOException;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;

public class DocStore {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.3.4.2 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static HttpClient client;
    private String iSessionID;

    public DocStore(String sessionId) {
        this.iSessionID = sessionId;
    }

    public boolean Store(File doc, String filename, Part[] postvars, String path, String pUsername) throws IOException {
        if (client == null) {
            client = new HttpClient();
        }
        String lPath = URIUtil.encodePathQuery((String)path);
        if (pUsername != null && lPath.indexOf("?") != -1) {
            lPath = String.valueOf(lPath) + "&cusername=" + pUsername;
        } else if (pUsername != null) {
            lPath = String.valueOf(lPath) + "?cusername=" + pUsername;
        }
        PostMethod post = new PostMethod(lPath);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Call docstore with path:" + lPath));
        }
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(postvars, post.getParams()));
        int postStatus = client.executeMethod((HttpMethod)post);
        return true;
    }

    public Long getSize(String path) throws IOException {
        Long lSize = null;
        path = path.indexOf("?") > 0 ? String.valueOf(path) + "&" : String.valueOf(path) + "?";
        path = String.valueOf(path) + "sid=" + this.iSessionID;
        if (client == null) {
            client = new HttpClient();
        }
        String lPath = URIUtil.encodePathQuery((String)path);
        HeadMethod head = new HeadMethod(lPath);
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("Call docstore head with path:" + lPath));
        }
        int postStatus = client.executeMethod((HttpMethod)head);
        if (head.getResponseHeader("Content-Length") == null) {
            return null;
        }
        String lStrSize = head.getResponseHeader("Content-Length").getValue();
        if (lStrSize != null && !lStrSize.isEmpty()) {
            lSize = new Long(lStrSize);
        }
        return lSize;
    }
}

