/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.vpreport;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import nl.buildersenperformers.vpreport.XmlToXlsxConverter;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class App {
    private static Logger log4j = Log4jUtil.createLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            log4j.error((Object)"Usage: java -jar vpReport.jar <input.xml> <output.xlsx>");
            System.exit(1);
        }
        Path in = Paths.get(args[0], new String[0]);
        Path out = Paths.get(args[1], new String[0]);
        if (!Files.exists(in, new LinkOption[0])) {
            log4j.error((Object)("Input XML not found: " + in.toAbsolutePath()));
            System.exit(2);
        }
        try {
            block17: {
                log4j.info((Object)("Converting XML -> XLSX: input=" + in.toAbsolutePath() + ", output=" + out.toAbsolutePath()));
                Files.createDirectories(out.getParent() != null ? out.getParent() : Paths.get(".", new String[0]), new FileAttribute[0]);
                XmlToXlsxConverter converter = new XmlToXlsxConverter();
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    FileInputStream fis = new FileInputStream(in.toFile());
                    try {
                        try (FileOutputStream fos = new FileOutputStream(out.toFile());){
                            converter.convert(fis, fos);
                        }
                        if (fis == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fis == null) throw throwable;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            log4j.info((Object)("Written: " + out.toAbsolutePath()));
            return;
        }
        catch (Exception e) {
            log4j.error((Object)"Conversion failed", (Throwable)e);
            System.exit(3);
        }
    }
}

