/*
 * Decompiled with CFR 0.152.
 */
package nl.buildersenperformers.vpreport;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.buildersenperformers.vpreport.styles.StyleDef;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlToXlsxConverter {
    private static Logger log4j = Log4jUtil.createLogger();

    public void convert(InputStream xmlIn, OutputStream xlsxOut) throws Exception {
        this.convert(xmlIn, xlsxOut, null);
    }

    public void convert(InputStream xmlIn, OutputStream xlsxOut, File externalStylesFile) throws Exception {
        Document doc = this.parse(xmlIn);
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        try {
            Map<String, StyleDef> config = StyleConfigLoader.get(externalStylesFile);
            StyleCache styleCache = new StyleCache(wb, config);
            log4j.debug((Object)"Starting XML to XLSX conversion");
            this.processTables(doc, wb, styleCache);
            wb.write(xlsxOut);
            log4j.debug((Object)"Finished XML to XLSX conversion");
        }
        finally {
            wb.dispose();
            wb.close();
        }
    }

    private Document parse(InputStream xmlIn) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Throwable t) {
            log4j.warn((Object)("XML parser does not support all hardening features: " + t.toString()));
        }
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(xmlIn, StandardCharsets.UTF_8.name());
    }

    private void processTables(Document doc, SXSSFWorkbook wb, StyleCache styleCache) {
        NodeList tables = doc.getElementsByTagName("attr");
        int[] sheetIndex = new int[]{1};
        int i = 0;
        while (i < tables.getLength()) {
            Element attr = (Element)tables.item(i);
            if ("table_list".equals(attr.getAttribute("fieldtype"))) {
                this.createSheetForAttr(attr, wb, styleCache, sheetIndex);
            }
            ++i;
        }
    }

    private void createSheetForAttr(Element attr, SXSSFWorkbook wb, StyleCache styleCache, int[] sheetIndex) {
        String sheetName = XmlToXlsxConverter.firstNonEmpty(attr.getAttribute("label"), "Sheet" + sheetIndex[0]);
        SXSSFSheet sheet = wb.createSheet(XmlToXlsxConverter.safeSheetName(sheetName));
        sheetIndex[0] = sheetIndex[0] + 1;
        log4j.info((Object)("Creating sheet: " + sheet.getSheetName()));
        NodeList headers = attr.getElementsByTagName("header");
        int colCount = headers.getLength();
        this.configureColumns(headers, (Sheet)sheet);
        int rowIdx = 0;
        if (colCount > 0) {
            rowIdx = this.writeHeaderRow(headers, (Sheet)sheet, styleCache);
        }
        rowIdx = this.writeDataRows(attr, (Sheet)sheet, styleCache, rowIdx);
        log4j.debug((Object)("Sheet '" + sheet.getSheetName() + "' created with " + colCount + " columns and " + rowIdx + " rows"));
    }

    private void configureColumns(NodeList headers, Sheet sheet) {
        int c = 0;
        while (c < headers.getLength()) {
            Element h = (Element)headers.item(c);
            this.setColumnWidthFromHeader(sheet, c, h);
            ++c;
        }
    }

    private void setColumnWidthFromHeader(Sheet sheet, int c, Element h) {
        block5: {
            String w = h.getAttribute("width");
            if (!XmlToXlsxConverter.isEmpty(w)) {
                try {
                    double width = Double.parseDouble(w);
                    if (width == 0.0) {
                        sheet.setColumnHidden(c, true);
                        break block5;
                    }
                    sheet.setColumnWidth(c, (int)(Math.max(8.0, width / 6.0) * 256.0));
                }
                catch (NumberFormatException width) {}
            } else {
                String text = h.getTextContent();
                int len = text != null ? text.length() + 1 : 8;
                sheet.setColumnWidth(c, Math.max(8, len) * 256);
            }
        }
    }

    private int writeHeaderRow(NodeList headers, Sheet sheet, StyleCache styleCache) {
        int rowIdx = 0;
        Row headerRow = sheet.createRow(rowIdx++);
        int c = 0;
        while (c < headers.getLength()) {
            Cell cell = headerRow.createCell(c);
            String text = headers.item(c).getTextContent();
            cell.setCellValue(text);
            cell.setCellStyle(styleCache.getStyle("1"));
            ++c;
        }
        return rowIdx;
    }

    private int writeDataRows(Element attr, Sheet sheet, StyleCache styleCache, int rowIdx) {
        NodeList items = attr.getElementsByTagName("item");
        int k = 0;
        while (k < items.getLength()) {
            Element item = (Element)items.item(k);
            if (!XmlToXlsxConverter.isEmpty(item.getAttribute("value"))) {
                Row row = sheet.createRow(rowIdx++);
                this.applyRowHeight(item, row);
                rowIdx = this.writeLabelsForRow(item, sheet, styleCache, row, rowIdx);
            }
            ++k;
        }
        return rowIdx;
    }

    private int writeLabelsForRow(Element item, Sheet sheet, StyleCache styleCache, Row row, int rowIdx) {
        NodeList labels = item.getElementsByTagName("label");
        int col = 0;
        int m = 0;
        while (m < labels.getLength()) {
            Element lbl = (Element)labels.item(m);
            Cell cell = row.createCell(col);
            this.applyCellStyle(item, styleCache, lbl, cell);
            int span = this.applyCellValueAndSpan(sheet, row, col, lbl, cell);
            col += span;
            ++m;
        }
        return rowIdx;
    }

    private void applyRowHeight(Element item, Row row) {
        String heightAttr = item.getAttribute("height");
        if (XmlToXlsxConverter.isEmpty(heightAttr)) {
            return;
        }
        try {
            double h = Double.parseDouble(heightAttr);
            if (h == 0.0) {
                row.setZeroHeight(true);
            } else {
                row.setHeightInPoints((float)h);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void applyCellStyle(Element item, StyleCache styleCache, Element lbl, Cell cell) {
        String styleId = XmlToXlsxConverter.firstNonEmpty(lbl.getAttribute("format"), item.getAttribute("style"));
        if (!XmlToXlsxConverter.isEmpty(styleId)) {
            cell.setCellStyle(styleCache.getStyle(styleId));
        }
    }

    private int applyCellValueAndSpan(Sheet sheet, Row row, int col, Element lbl, Cell cell) {
        String type = XmlToXlsxConverter.firstNonEmpty(lbl.getAttribute("type"), "String");
        String raw = lbl.getTextContent();
        String formula = lbl.getAttribute("formule");
        String formulaSyntax = lbl.getAttribute("formulaSyntax");
        if (!XmlToXlsxConverter.isEmpty(formula)) {
            String a1;
            String f = formula.startsWith("=") ? formula.substring(1) : formula;
            boolean forceA1 = "a1".equalsIgnoreCase(formulaSyntax);
            if (!forceA1 && XmlToXlsxConverter.isLikelyR1C1(f)) {
                try {
                    a1 = XmlToXlsxConverter.toA1Formula(f, row.getRowNum(), col);
                }
                catch (Exception ex) {
                    a1 = f;
                }
            } else {
                a1 = f;
            }
            if (XmlToXlsxConverter.referencesCurrentCellA1(a1, row.getRowNum(), col)) {
                log4j.warn((Object)("Circular reference detected at cell (row=" + (row.getRowNum() + 1) + ", col=" + (col + 1) + ") for formula: " + a1));
            } else {
                cell.setCellFormula(a1);
            }
        } else {
            this.setTypedValue(cell, type, raw);
        }
        int span = this.parseSpan(lbl.getAttribute("colspan"));
        if (span > 1) {
            this.mergeAcross(sheet, row, col, span);
        }
        return span;
    }

    private void setTypedValue(Cell cell, String type, String raw) {
        switch (type) {
            case "Number": {
                try {
                    cell.setCellValue(Double.parseDouble(raw.replace(',', '.')));
                }
                catch (NumberFormatException e) {
                    cell.setCellValue(raw);
                }
                break;
            }
            case "DateTime": {
                cell.setCellValue(raw);
                break;
            }
            case "Boolean": {
                cell.setCellValue("1".equals(raw) || Boolean.parseBoolean(raw));
                break;
            }
            default: {
                cell.setCellValue(raw);
            }
        }
    }

    private int parseSpan(String colspan) {
        try {
            if (!XmlToXlsxConverter.isEmpty(colspan)) {
                return Math.max(1, Integer.parseInt(colspan));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 1;
    }

    private void mergeAcross(Sheet sheet, Row row, int col, int span) {
        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), col, col + span - 1));
        int s = 1;
        while (s < span) {
            row.createCell(col + s);
            ++s;
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static String firstNonEmpty(String a, String b) {
        return a != null && !a.trim().isEmpty() ? a : (b != null && !b.trim().isEmpty() ? b : "");
    }

    private static String safeSheetName(String name) {
        String n = name.replaceAll("[\\\\/*?\\n\\r\\[\\]]", " ");
        return n.length() > 31 ? n.substring(0, 31) : n;
    }

    private static Color parseColor(String hex) {
        String s = hex.toUpperCase(Locale.ROOT);
        return Color.decode(s);
    }

    private static Short tryIndexed(String hex) {
        if (hex == null) {
            return null;
        }
        String s = hex.toUpperCase(Locale.ROOT);
        if ("#FF0000".equals(s)) {
            return IndexedColors.RED.getIndex();
        }
        if ("#000000".equals(s)) {
            return IndexedColors.BLACK.getIndex();
        }
        if ("#FFFFFF".equals(s)) {
            return IndexedColors.WHITE.getIndex();
        }
        return null;
    }

    private static HorizontalAlignment mapHorizontal(String s) {
        if (s == null) {
            return HorizontalAlignment.GENERAL;
        }
        String v = s.toLowerCase(Locale.ROOT);
        if ("left".equals(v)) {
            return HorizontalAlignment.LEFT;
        }
        if ("center".equals(v)) {
            return HorizontalAlignment.CENTER;
        }
        if ("right".equals(v)) {
            return HorizontalAlignment.RIGHT;
        }
        return HorizontalAlignment.GENERAL;
    }

    private static VerticalAlignment mapVertical(String s) {
        if (s == null) {
            return VerticalAlignment.BOTTOM;
        }
        String v = s.toLowerCase(Locale.ROOT);
        if ("top".equals(v)) {
            return VerticalAlignment.TOP;
        }
        if ("middle".equals(v)) {
            return VerticalAlignment.CENTER;
        }
        if ("bottom".equals(v)) {
            return VerticalAlignment.BOTTOM;
        }
        return VerticalAlignment.BOTTOM;
    }

    private static boolean isLikelyR1C1(String f) {
        if (XmlToXlsxConverter.isEmpty(f)) {
            return false;
        }
        String s = f.toUpperCase(Locale.ROOT);
        return s.matches(".*R(\\[[-]?[\\d]++\\]|[\\d]++)?C(\\[[-]?[\\d]++\\]|[\\d]++)?.*");
    }

    private static String toA1Formula(String r1c1, int baseRow, int baseCol) {
        Pattern p = Pattern.compile("R(\\[(-?\\d+)\\]|(\\d+))?C(\\[(-?\\d+)\\]|(\\d+))?", 2);
        Matcher m = p.matcher(r1c1);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            boolean absCol;
            String relRowNum = m.group(2);
            String absRowNum = m.group(3);
            String relColNum = m.group(5);
            String absColNum = m.group(6);
            boolean absRow = absRowNum != null;
            boolean bl = absCol = absColNum != null;
            int targetRow = absRow ? Integer.parseInt(absRowNum) - 1 : (relRowNum != null ? baseRow + Integer.parseInt(relRowNum) : baseRow);
            int targetCol = absCol ? Integer.parseInt(absColNum) - 1 : (relColNum != null ? baseCol + Integer.parseInt(relColNum) : baseCol);
            String a1ref = String.valueOf(absCol ? "$" : "") + XmlToXlsxConverter.toA1Col(targetCol) + (absRow ? "$" : "") + (targetRow + 1);
            m.appendReplacement(sb, Matcher.quoteReplacement(a1ref));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String toA1Col(int colIndex) {
        int x = colIndex;
        StringBuilder sb = new StringBuilder();
        if (x < 0) {
            x = 0;
        }
        while (x >= 0) {
            int rem = x % 26;
            sb.append((char)(65 + rem));
            x = x / 26 - 1;
        }
        return sb.reverse().toString();
    }

    private static boolean referencesCurrentCellA1(String a1, int baseRow, int baseCol) {
        if (XmlToXlsxConverter.isEmpty(a1)) {
            return false;
        }
        String s = a1.toUpperCase(Locale.ROOT);
        Pattern cellRef = Pattern.compile("\\$?[A-Z]{1,3}\\$?\\d+");
        Pattern rangeRef = Pattern.compile("(\\$?[A-Z]{1,3}\\$?\\d+):(\\$?[A-Z]{1,3}\\$?\\d+)");
        Matcher mr = rangeRef.matcher(s);
        while (mr.find()) {
            int[] a = XmlToXlsxConverter.a1ToRowCol(mr.group(1));
            int[] b = XmlToXlsxConverter.a1ToRowCol(mr.group(2));
            if (a == null || b == null) continue;
            int r1 = Math.min(a[0], b[0]);
            int r2 = Math.max(a[0], b[0]);
            int c1 = Math.min(a[1], b[1]);
            int c2 = Math.max(a[1], b[1]);
            if (baseRow < r1 || baseRow > r2 || baseCol < c1 || baseCol > c2) continue;
            return true;
        }
        Matcher mc = cellRef.matcher(s);
        while (mc.find()) {
            int[] rc = XmlToXlsxConverter.a1ToRowCol(mc.group());
            if (rc == null || rc[0] != baseRow || rc[1] != baseCol) continue;
            return true;
        }
        return false;
    }

    private static int[] a1ToRowCol(String a1) {
        if (a1 == null) {
            return null;
        }
        String s = a1.toUpperCase(Locale.ROOT);
        int i = 0;
        int n = s.length();
        boolean absCol = false;
        boolean absRow = false;
        if (i < n && s.charAt(i) == '$') {
            absCol = true;
            ++i;
        }
        int col = 0;
        int letters = 0;
        while (i < n) {
            char ch = s.charAt(i);
            if (ch < 'A' || ch > 'Z') break;
            col = col * 26 + (ch - 65 + 1);
            ++i;
            ++letters;
        }
        if (letters == 0) {
            return null;
        }
        if (i < n && s.charAt(i) == '$') {
            absRow = true;
            ++i;
        }
        StringBuilder num = new StringBuilder();
        while (i < n && Character.isDigit(s.charAt(i))) {
            num.append(s.charAt(i++));
        }
        if (num.length() == 0) {
            return null;
        }
        int row = Integer.parseInt(num.toString());
        return new int[]{row - 1, col - 1};
    }

    private static class StyleCache {
        private final SXSSFWorkbook wb;
        private final Map<String, CellStyle> cache = new HashMap<String, CellStyle>();
        private final CellStyle defaultStyle;
        private final Map<String, StyleDef> config;
        private final CellStyle defaultConfiguredStyle;

        StyleCache(SXSSFWorkbook wb) {
            this(wb, null);
        }

        StyleCache(SXSSFWorkbook wb, Map<String, StyleDef> config) {
            this.wb = wb;
            this.defaultStyle = wb.createCellStyle();
            this.config = config != null ? config : new HashMap();
            this.defaultConfiguredStyle = this.config.containsKey("Default") ? this.createFromDef(this.config.get("Default")) : null;
        }

        CellStyle getStyle(String id) {
            if (XmlToXlsxConverter.isEmpty(id)) {
                return this.defaultConfiguredStyle != null ? this.defaultConfiguredStyle : this.defaultStyle;
            }
            if (id.startsWith("Grf") && !this.config.containsKey(id)) {
                return this.defaultConfiguredStyle != null ? this.defaultConfiguredStyle : this.defaultStyle;
            }
            if (this.config.containsKey(id)) {
                return this.cache.computeIfAbsent(id, k -> this.createFromDef(this.config.get(k)));
            }
            return this.defaultConfiguredStyle != null ? this.defaultConfiguredStyle : this.defaultStyle;
        }

        private CellStyle createFromDef(StyleDef def) {
            XSSFCellStyle cs = (XSSFCellStyle)this.wb.createCellStyle();
            if (def == null) {
                return cs;
            }
            if (def.dataFormat != null && !def.dataFormat.trim().isEmpty()) {
                cs.setDataFormat(this.wb.createDataFormat().getFormat(def.dataFormat));
            }
            if (def.font != null) {
                XSSFFont f = (XSSFFont)this.wb.createFont();
                if (def.font.name != null) {
                    f.setFontName(def.font.name);
                }
                if (Boolean.TRUE.equals(def.font.bold)) {
                    f.setBold(true);
                }
                if (Boolean.TRUE.equals(def.font.italic)) {
                    f.setItalic(true);
                }
                if (def.font.underline != null && "single".equalsIgnoreCase(def.font.underline)) {
                    f.setUnderline((byte)1);
                }
                if (def.font.color != null) {
                    f.setColor(new XSSFColor(XmlToXlsxConverter.parseColor(def.font.color), null));
                }
                cs.setFont((Font)f);
            }
            if (def.fill != null && def.fill.color != null) {
                cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cs.setFillForegroundColor(new XSSFColor(XmlToXlsxConverter.parseColor(def.fill.color), null));
            }
            if (def.align != null) {
                if (def.align.horizontal != null) {
                    cs.setAlignment(XmlToXlsxConverter.mapHorizontal(def.align.horizontal));
                }
                if (def.align.vertical != null) {
                    cs.setVerticalAlignment(XmlToXlsxConverter.mapVertical(def.align.vertical));
                }
                if (def.align.wrap != null) {
                    cs.setWrapText(def.align.wrap.booleanValue());
                }
            }
            if (def.borders != null) {
                this.applyBorder(cs, def.borders.top, BorderSide.TOP);
                this.applyBorder(cs, def.borders.right, BorderSide.RIGHT);
                this.applyBorder(cs, def.borders.bottom, BorderSide.BOTTOM);
                this.applyBorder(cs, def.borders.left, BorderSide.LEFT);
            }
            return cs;
        }

        private void applyBorder(XSSFCellStyle cs, StyleDef.BorderEdge edge, BorderSide side) {
            if (edge == null) {
                return;
            }
            BorderStyle style = this.mapBorderStyle(edge.style, edge.weight);
            switch (side) {
                case TOP: {
                    cs.setBorderTop(style);
                    break;
                }
                case RIGHT: {
                    cs.setBorderRight(style);
                    break;
                }
                case BOTTOM: {
                    cs.setBorderBottom(style);
                    break;
                }
                case LEFT: {
                    cs.setBorderLeft(style);
                }
            }
            if (edge.color != null) {
                XSSFColor color = new XSSFColor(XmlToXlsxConverter.parseColor(edge.color), null);
                switch (side) {
                    case TOP: {
                        cs.setTopBorderColor(color);
                        break;
                    }
                    case RIGHT: {
                        cs.setRightBorderColor(color);
                        break;
                    }
                    case BOTTOM: {
                        cs.setBottomBorderColor(color);
                        break;
                    }
                    case LEFT: {
                        cs.setLeftBorderColor(color);
                    }
                }
            }
        }

        private BorderStyle mapBorderStyle(String s, Integer weight) {
            if (s != null) {
                String v = s.toLowerCase(Locale.ROOT);
                if ("thin".equals(v)) {
                    return BorderStyle.THIN;
                }
                if ("medium".equals(v)) {
                    return BorderStyle.MEDIUM;
                }
                if ("thick".equals(v)) {
                    return BorderStyle.THICK;
                }
                if ("dashed".equals(v)) {
                    return BorderStyle.DASHED;
                }
                if ("dotted".equals(v)) {
                    return BorderStyle.DOTTED;
                }
                if ("double".equals(v)) {
                    return BorderStyle.DOUBLE;
                }
                if ("hair".equals(v)) {
                    return BorderStyle.HAIR;
                }
                if ("none".equals(v)) {
                    return BorderStyle.NONE;
                }
            }
            if (weight != null) {
                if (weight >= 3) {
                    return BorderStyle.MEDIUM;
                }
                if (weight <= 0) {
                    return BorderStyle.NONE;
                }
                return BorderStyle.THIN;
            }
            return BorderStyle.THIN;
        }

        private static enum BorderSide {
            TOP,
            RIGHT,
            BOTTOM,
            LEFT;

        }
    }

    private static class StyleConfigLoader {
        private static Map<String, StyleDef> cached = null;
        private static long cachedAt = 0L;
        private static long extLastModified = -1L;
        private static String cachedPath = "<none>";

        private StyleConfigLoader() {
        }

        static Map<String, StyleDef> get(File externalFile) {
            long ttl = StyleConfigLoader.getTtlMillis();
            String externalPath = externalFile != null ? externalFile.getAbsolutePath() : null;
            long now = System.currentTimeMillis();
            boolean expired = now - cachedAt > ttl;
            boolean pathChanged = externalPath == null && cachedPath != null || externalPath != null && !externalPath.equals(cachedPath);
            boolean changed = false;
            if (externalFile != null && externalFile.isFile()) {
                long lm = externalFile.lastModified();
                if (lm != extLastModified) {
                    changed = true;
                    extLastModified = lm;
                }
            } else if (extLastModified != -1L) {
                changed = true;
                extLastModified = -1L;
            }
            if (cached == null || expired || changed || pathChanged) {
                cached = StyleConfigLoader.loadCombined(externalFile);
                cachedAt = now;
                cachedPath = externalPath;
            }
            return cached;
        }

        private static Map<String, StyleDef> loadCombined(File externalFile) {
            Object var3_7;
            HashMap<String, StyleDef> combined = new HashMap<String, StyleDef>();
            try {
                Throwable throwable = null;
                var3_7 = null;
                try (InputStream in = XmlToXlsxConverter.class.getResourceAsStream("/excelStyles.json");){
                    if (in != null) {
                        Map<String, StyleDef> base = StyleConfigLoader.parseJsonStyles(in);
                        combined.putAll(base);
                        log4j.info((Object)("Loaded default excelStyles.json from classpath (" + base.size() + " styles)"));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log4j.warn((Object)("Failed to load styles from classpath: " + e.toString()));
            }
            if (externalFile != null && externalFile.isFile()) {
                try {
                    Throwable e = null;
                    var3_7 = null;
                    try (FileInputStream fis = new FileInputStream(externalFile);){
                        Map<String, StyleDef> ext = StyleConfigLoader.parseJsonStyles(fis);
                        combined.putAll(ext);
                        log4j.info((Object)("Loaded external excelStyles.json from " + externalFile.getAbsolutePath() + " (overrides: " + ext.size() + " styles)"));
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    log4j.warn((Object)("Failed to load external styles from " + externalFile.getAbsolutePath() + ": " + e.toString()));
                }
            }
            return combined;
        }

        private static Map<String, StyleDef> parseJsonStyles(InputStream in) throws Exception {
            ObjectMapper om = new ObjectMapper();
            return (Map)om.readValue(in, (JavaType)om.getTypeFactory().constructMapType(Map.class, String.class, StyleDef.class));
        }

        private static long getTtlMillis() {
            String v = System.getProperty("excelStyles.ttlMillis", "10000");
            try {
                return Long.parseLong(v);
            }
            catch (NumberFormatException e) {
                return 10000L;
            }
        }
    }
}

