/*
 * Decompiled with CFR 0.152.
 */
package nl.gezondheidsmeter.short_login;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.gezondheidsmeter.short_login.RegistrationDAO;
import nl.gezondheidsmeter.short_login.model.AppRegRequest;
import nl.gezondheidsmeter.short_login.model.AppRegResponse;
import nl.gezondheidsmeter.short_login.model.CodeRegRequest;
import nl.gezondheidsmeter.short_login.model.GenericResponse;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class RegistrationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log4j = Log4jUtil.createLogger();

    protected void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doPost(pReq, pResp);
    }

    protected void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        String lPath = pReq.getPathInfo();
        log4j.debug((Object)("handeling action: " + lPath));
        if (lPath.equals("/app_reg")) {
            this.RegisterApp(pReq, pResp);
        } else if (lPath.equals("/code_reg")) {
            try {
                this.RegisterCode(pReq, pResp);
            }
            catch (Exception e) {
                GenericResponse lResp = new GenericResponse();
                lResp.setError(e.getMessage());
                Gson gson = new Gson();
                pResp.getWriter().print(gson.toJson((Object)lResp));
            }
        } else {
            log4j.warn((Object)"Invallid action");
            throw new ServletException("Invallid action");
        }
    }

    private void RegisterCode(HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        log4j.info((Object)"Start RegistrationServlet.RegisterCode");
        Gson gson = new Gson();
        CodeRegRequest lReq = new CodeRegRequest();
        lReq = (CodeRegRequest)gson.fromJson((Reader)pReq.getReader(), lReq.getClass());
        log4j.debug((Object)("UserApp ID: " + lReq.getUserAppID()));
        log4j.debug((Object)("Code: " + lReq.getCode()));
        log4j.debug((Object)("CodeVerify: " + lReq.getCodeVerify()));
        log4j.debug((Object)("Signature: " + lReq.getSignature()));
        RegistrationDAO lDAO = new RegistrationDAO(pReq);
        GenericResponse lResp = new GenericResponse();
        lDAO.RegisterCode(lReq, lResp);
        lResp.setResult("OK");
        pResp.getWriter().print(gson.toJson((Object)lResp));
        log4j.info((Object)"End RegistrationServlet.RegisterCode");
    }

    private void RegisterApp(HttpServletRequest pReq, HttpServletResponse pResp) throws IOException, ServletException {
        log4j.info((Object)"Start RegistrationServlet.RegisterApp");
        Gson gson = new Gson();
        RegistrationDAO lDAO = new RegistrationDAO(pReq);
        AppRegRequest lReq = new AppRegRequest();
        lReq = (AppRegRequest)gson.fromJson((Reader)pReq.getReader(), lReq.getClass());
        if (lReq != null) {
            log4j.debug((Object)("Device ID: " + lReq.getDeviceID()));
            log4j.debug((Object)("DeviceType: " + lReq.getDeviceType()));
            log4j.debug((Object)("DeviceName: " + lReq.getDeviceName()));
            log4j.debug((Object)("PhoneNumber: " + lReq.getPhoneNumber()));
            log4j.debug((Object)("Imei: " + lReq.getImei()));
            log4j.debug((Object)("UserAppId: " + lReq.getUserAppID()));
        }
        AppRegResponse lResp = new AppRegResponse();
        lResp.setSessionToken(pReq.getSession().getId());
        int lResult = lDAO.RegisterApp(lReq, lResp);
        if (lResult != 1) {
            GenericResponse lError = new GenericResponse();
            lError.setResult("ERROR");
            if (lResult == 2) {
                lError.setError("Verplicht veld in reguest is leeg");
            } else if (lResult == 3) {
                lError.setError("Veld in reguest is te groot");
            } else {
                lError.setError("Overige fout");
            }
            String json = gson.toJson((Object)lError);
            pResp.setContentType("application/json");
            pResp.getWriter().print(json);
            log4j.debug((Object)("JSON Response: " + json));
        } else {
            String json = gson.toJson((Object)lResp);
            pResp.setContentType("application/json");
            pResp.getWriter().print(json);
            log4j.debug((Object)("JSON Response: " + json));
        }
        log4j.info((Object)"End RegistrationServlet.RegisterApp");
    }
}

