/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.servlet;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.innovationinvestments.cheyenne.engine.Dialog;
import nl.innovationinvestments.cheyenne.engine.servlet.Context;
import nl.knowledgeplaza.util.CollectionUtil;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.StringUtil;
import org.apache.log4j.Logger;

public class AccessLogger {
    private static Logger log4j = Log4jUtil.createLogger();
    private static Logger log4jAccess = Logger.getLogger((String)"chyAccessLog");
    private static List iLogParameters = new ArrayList();
    private static boolean iInitialized = false;
    private static int iFixedParams = 11;

    private AccessLogger() {
        throw new IllegalStateException("Utility class");
    }

    public static void init() {
        if (!iInitialized) {
            iInitialized = true;
            ConfigurationProperties iConfigurationProperties = ConfigurationProperties.get();
            iLogParameters.addAll(iConfigurationProperties.getGroupedCollection("chyAccessLog.logParameters").values());
        }
    }

    public static String logStart(HttpServletRequest pRequest, String pResponse, Dialog pDialog, Context lContext) {
        UID lId = new UID();
        String lRequestID = lId.toString();
        AccessLogger.log(pRequest, pResponse, lContext, pDialog, "START", lRequestID);
        return lRequestID;
    }

    public static void logEnd(HttpServletRequest pRequest, String pResponse, Context lContext, Dialog pDialog, String pRequestID) {
        AccessLogger.log(pRequest, pResponse, lContext, pDialog, "END", pRequestID);
    }

    public static void logError(HttpServletRequest pRequest, String pResponse, Context lContext, Dialog pDialog, String pRequestID) {
        AccessLogger.log(pRequest, pResponse, lContext, pDialog, "ERROR", pRequestID);
    }

    public static void log(HttpServletRequest pRequest, String pResponse, Context lContext, Dialog pDialog, String pMarker, String pRequestID) {
        HttpSession lSess = pRequest.getSession(false);
        String[] lLogParameters = new String[iLogParameters.size() + iFixedParams];
        lLogParameters[0] = pRequestID;
        lLogParameters[1] = pMarker;
        lLogParameters[2] = pRequest.getRemoteAddr();
        if (lContext != null) {
            lLogParameters[3] = lContext.getConfigurationParameter("SESSIONID");
            lLogParameters[4] = lContext.getConfigurationParameter("cusername");
        } else {
            lLogParameters[3] = pRequest.getSession().getId();
            lLogParameters[4] = pRequest.getUserPrincipal().getName();
        }
        if (pDialog != null) {
            lLogParameters[5] = pDialog.getRole();
        }
        lLogParameters[6] = pRequest.getMethod();
        lLogParameters[7] = pRequest.getRequestURI() + (pRequest.getQueryString() != null ? "?" + pRequest.getQueryString() : "");
        lLogParameters[8] = pResponse;
        lLogParameters[9] = pRequest.getHeader("referer") != null ? "" + pRequest.getHeader("referer") : "";
        lLogParameters[10] = CollectionUtil.toString((Map)pRequest.getParameterMap());
        String lUrlParam = "";
        String lUrlParamDefault = "";
        for (int i = 0; i < iLogParameters.size(); ++i) {
            lUrlParam = (String)((Map)iLogParameters.get(i)).get("UrlParam");
            lUrlParamDefault = (String)((Map)iLogParameters.get(i)).get("Default");
            lLogParameters[i + AccessLogger.iFixedParams] = "" + lUrlParamDefault;
            for (String lParam : lUrlParam.split(",")) {
                String lDiagValue;
                if (pRequest.getParameter(lParam) != null) {
                    lLogParameters[i + AccessLogger.iFixedParams] = "" + pRequest.getParameter(lParam);
                    break;
                }
                if (lSess.getAttribute(lParam) != null) {
                    lLogParameters[i + AccessLogger.iFixedParams] = "" + lSess.getAttribute(lParam).toString();
                    break;
                }
                if (pDialog == null || (lDiagValue = pDialog.resolve("%" + lParam + "%")) == null || lDiagValue.isEmpty()) continue;
                lLogParameters[i + AccessLogger.iFixedParams] = "" + lDiagValue;
                break;
            }
            if (!log4j.isDebugEnabled()) continue;
            log4j.debug((Object)("Log Parameter: " + lUrlParam + " value: " + lLogParameters[i + iFixedParams]));
        }
        String lLogLine = StringUtil.makeCSV((String)"\t", (String[])lLogParameters);
        log4jAccess.info((Object)lLogLine);
    }
}

