/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.knowledgeplaza.servlets.ServletUtil;
import nl.knowledgeplaza.servlets.log4j.InitServlet;
import nl.knowledgeplaza.util.CalendarUtil;
import nl.knowledgeplaza.util.CollectionUtil;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.ExceptionUtil;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.StringUtil;
import org.apache.log4j.Logger;

public class CheyenneProxy
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SOURCECODE_VERSION = "$Revision: 1.5 $";
    private static Logger log4j = Log4jUtil.createLogger();
    public static final String EXCEPTION_COUNTER = CheyenneProxy.class.getName() + ".Exception";
    public static final String EXCEPTION = CheyenneProxy.class.getName() + ".Exception";
    public static final String EXCEPTION_ID = CheyenneProxy.class.getName() + ".ExceptionId";
    public static final String EXCEPTION_MESSAGE = CheyenneProxy.class.getName() + ".ExceptionMessage";
    public static final String ANNOTATION_ALLOWCACHE = "allowCache";
    public static final String ANNOTATION_DOWNLOADAS = "downloadAs";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        InitServlet.setNDC((ServletContext)servletConfig.getServletContext());
        if (log4j.isInfoEnabled()) {
            log4j.info((Object)("initializing " + ((Object)((Object)this)).getClass().getName()));
        }
        servletConfig.getServletContext().setAttribute(EXCEPTION_COUNTER, (Object)new AtomicLong());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            InitServlet.setNDC((HttpServletRequest)request);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)"==========================");
            }
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("processing request: " + request.getMethod() + " " + request.getRequestURL() + " / " + CollectionUtil.toString((Map)request.getParameterMap())));
            }
            URL url = new URL(request.getParameter("url"));
            log4j.info((Object)("User " + request.getUserPrincipal().getName() + " requested proxy for " + url));
            URLConnection urlConnection = url.openConnection();
            response.setContentType(urlConnection.getContentType());
            try {
                response.setContentLength(Integer.parseInt(urlConnection.getHeaderField("Content-Length")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            response.addHeader("Content-Encoding", urlConnection.getHeaderField("Content-Encoding"));
            response.addHeader("Last-Modified", urlConnection.getHeaderField("Last-Modified"));
            response.addHeader("Cache-Control", urlConnection.getHeaderField("Cache-Control"));
            response.addHeader("Expires", urlConnection.getHeaderField("Expires"));
            response.addHeader("Etag", urlConnection.getHeaderField("Etag"));
            IOUtil.copy((InputStream)urlConnection.getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (Throwable t) {
            this.handleThrowable(t, request, response);
        }
    }

    private void handleThrowable(Throwable throwable, HttpServletRequest request, HttpServletResponse response) {
        try {
            String lExceptionHandling;
            AtomicLong lExceptionCounter = (AtomicLong)request.getSession().getServletContext().getAttribute(EXCEPTION_COUNTER);
            String lId = "#" + CalendarUtil.filePrefixLong() + "_" + lExceptionCounter.addAndGet(1L);
            String lMessage = lId + "\n\n" + throwable.getMessage() + "\n\n" + ServletUtil.describeFull((HttpServletRequest)request) + "\n\n" + ExceptionUtil.describe((Throwable)throwable);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)lMessage);
            }
            if (StringUtil.equalsTrueInSomeForm((String)(lExceptionHandling = ConfigurationProperties.get().get2((Object)this, "exceptionHandling")))) {
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"ExceptionHandling is true, so we just print a simple text");
                }
                response.setStatus(500);
                response.setContentType("text/plain");
                response.getWriter().write("Er is een fout opgetreden, meldt het volgende nummer aan de helpdesk " + lId);
            } else {
                if (!StringUtil.isEmpty((String)lExceptionHandling)) {
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("ExceptionHandling is " + lExceptionHandling + ", so we will forward the request there"));
                    }
                    request.setAttribute(EXCEPTION, (Object)throwable);
                    request.setAttribute(EXCEPTION_ID, (Object)lId);
                    request.setAttribute(EXCEPTION_MESSAGE, (Object)lMessage);
                    request.getRequestDispatcher(lExceptionHandling).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (log4j.isDebugEnabled()) {
                    log4j.debug((Object)"ExceptionHandling is not set, so we will dump the exception");
                }
                log4j.error((Object)lMessage);
                response.setStatus(500);
                response.setContentType("text/plain");
                response.getWriter().write(lMessage);
            }
        }
        catch (Throwable t) {
            log4j.error((Object)(ExceptionUtil.describe((Throwable)t) + "\n\n\nWHEN HANDLING:\n\n" + ExceptionUtil.describe((Throwable)throwable)));
        }
    }
}

