/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.servlet;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureClassLoader;
import javax.servlet.ServletContext;
import nl.innovationinvestments.cheyenne.engine.servlet.DialogLoader;
import nl.innovationinvestments.cheyenne.engine.servlet.DialogRuntimeContext;
import nl.innovationinvestments.cheyenne.engine.servlet.DialogWrapper;
import nl.knowledgeplaza.util.ExceptionUtil;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class DialogLoaderContext {
    private static Logger log4j = Log4jUtil.createLogger();
    private String cddid;
    private DialogWrapper dw;
    private ServletContext context;
    private DialogRuntimeContext rctxt;
    protected Class servletClass;
    protected SecureClassLoader dialogLoader = null;
    private ClassLoader loader;

    DialogLoaderContext(String cddid, ServletContext context, DialogWrapper dw, DialogRuntimeContext rctxt) {
        this.cddid = cddid;
        this.dw = dw;
        this.context = context;
        this.rctxt = rctxt;
    }

    public Class load() throws ClassNotFoundException {
        this.getDialogLoader();
        String name = this.cddid;
        this.servletClass = this.dialogLoader.loadClass(name);
        return this.servletClass;
    }

    private ClassLoader getDialogLoader() {
        if (this.dialogLoader == null) {
            URL lURL;
            block6: {
                lURL = null;
                try {
                    File lClassesDir = new File(this.context.getRealPath("/WEB-INF/classes"));
                    if (log4j.isDebugEnabled()) {
                        log4j.debug((Object)("Checking for classloader " + lClassesDir.getAbsolutePath()));
                    }
                    if (lClassesDir.exists()) {
                        lURL = lClassesDir.toURI().toURL();
                        if (log4j.isDebugEnabled()) {
                            log4j.debug((Object)("Adding to classloader " + lURL));
                        }
                    }
                }
                catch (MalformedURLException e) {
                    if (!log4j.isDebugEnabled()) break block6;
                    log4j.debug((Object)(lURL + "\n" + ExceptionUtil.describe((Throwable)e)));
                }
            }
            this.dialogLoader = new DialogLoader(new URL[]{lURL}, this.getClassLoader());
        }
        return this.dialogLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.rctxt.getParentClassLoader();
    }
}

