/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.cheyenne.engine.servlet;

import java.security.SecureClassLoader;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import nl.innovationinvestments.cheyenne.engine.servlet.DialogWrapper;

public class DialogRuntimeContext {
    private ServletContext context;
    private SecureClassLoader parentClassLoader;
    Map<String, DialogWrapper> iCddids = new ConcurrentHashMap<String, DialogWrapper>();

    public DialogRuntimeContext(ServletContext pContext) {
        this.context = pContext;
        this.parentClassLoader = (SecureClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = (SecureClassLoader)this.getClass().getClassLoader();
        }
    }

    public void addWrapper(String cddid, DialogWrapper dw) {
        this.iCddids.put(cddid, dw);
    }

    public DialogWrapper getWrapper(String cddid) {
        return this.iCddids.get(cddid);
    }

    public void removeWrapper(String cddid) {
        this.iCddids.remove(cddid);
    }

    public void destroy() {
        Iterator<DialogWrapper> diags = this.iCddids.values().iterator();
        while (diags.hasNext()) {
            diags.next().destroy();
        }
    }

    public SecureClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }
}

