/*
 * Decompiled with CFR 0.152.
 */
package nl.innovationinvestments.docstore.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.sql.JdbcBase;
import nl.buildersenperformers.xam.engine.sql.NamedParameterStatement;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Log4jUtil;
import org.apache.log4j.Logger;

public class QueryUtil
extends JdbcBase {
    public static final String SOURCECODE_VERSION = "$Revision: 1.5 $";
    private static Logger log4j = Log4jUtil.createLogger();

    public QueryUtil() {
        String ldefaultPoolName = ConfigurationProperties.get().get("xam.jdbcPoolName");
        if (log4j.isDebugEnabled()) {
            log4j.debug((Object)("defaultJdbcConnectionName: " + ldefaultPoolName));
        }
        this.initPool(ldefaultPoolName);
    }

    public String getValueByQuery(String lDbQString, Map<String, List<String>> lParameters, String uploadedFilename, Map<String, String> iParamReplacements) throws QueryUtilException {
        Connection conn = null;
        try {
            String string;
            conn = this.getConnection();
            String lQuery = lDbQString;
            NamedParameterStatement lNPS = new NamedParameterStatement(conn, lQuery);
            try {
                lNPS.setString("filename", uploadedFilename);
            }
            catch (IllegalArgumentException e) {
                String msg = "Failed to set filename parameter";
                log4j.warn((Object)msg, (Throwable)e);
            }
            for (String lName : lParameters.keySet()) {
                String lValue = lParameters.get(lName).get(0);
                try {
                    lNPS.setString(lName, lValue);
                }
                catch (IllegalArgumentException e) {
                    String msg = "Failed to set parameter " + lName;
                    log4j.warn((Object)msg, (Throwable)e);
                }
            }
            log4j.info((Object)("SQL: " + lNPS.getStatement().toString()));
            ResultSet lRS = lNPS.executeQuery();
            conn.commit();
            if (lRS.next()) {
                iParamReplacements.put("P_DOC_ID", "" + lRS.getInt(2));
                string = lRS.getString(1);
                return string;
            }
            string = null;
            return string;
        }
        catch (Exception e) {
            String msg = "Failed to get value by query";
            log4j.error((Object)msg, (Throwable)e);
            throw new QueryUtilException(msg, e);
        }
        finally {
            this.returnConnection(conn);
        }
    }

    public static class QueryUtilException
    extends Exception {
        public QueryUtilException(String msg) {
            super(msg);
        }

        public QueryUtilException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

