// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Android Minimum Operating System.
 */
public class AndroidMinimumOperatingSystem implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The V10_0.
     * Version 10.0 or later.
     */
    @SerializedName(value = "v10_0", alternate = {"V10_0"})
    @Expose
	@Nullable
    public Boolean v10_0;

    /**
     * The V11_0.
     * Version 11.0 or later.
     */
    @SerializedName(value = "v11_0", alternate = {"V11_0"})
    @Expose
	@Nullable
    public Boolean v11_0;

    /**
     * The V4_0.
     * Version 4.0 or later.
     */
    @SerializedName(value = "v4_0", alternate = {"V4_0"})
    @Expose
	@Nullable
    public Boolean v4_0;

    /**
     * The V4_0_3.
     * Version 4.0.3 or later.
     */
    @SerializedName(value = "v4_0_3", alternate = {"V4_0_3"})
    @Expose
	@Nullable
    public Boolean v4_0_3;

    /**
     * The V4_1.
     * Version 4.1 or later.
     */
    @SerializedName(value = "v4_1", alternate = {"V4_1"})
    @Expose
	@Nullable
    public Boolean v4_1;

    /**
     * The V4_2.
     * Version 4.2 or later.
     */
    @SerializedName(value = "v4_2", alternate = {"V4_2"})
    @Expose
	@Nullable
    public Boolean v4_2;

    /**
     * The V4_3.
     * Version 4.3 or later.
     */
    @SerializedName(value = "v4_3", alternate = {"V4_3"})
    @Expose
	@Nullable
    public Boolean v4_3;

    /**
     * The V4_4.
     * Version 4.4 or later.
     */
    @SerializedName(value = "v4_4", alternate = {"V4_4"})
    @Expose
	@Nullable
    public Boolean v4_4;

    /**
     * The V5_0.
     * Version 5.0 or later.
     */
    @SerializedName(value = "v5_0", alternate = {"V5_0"})
    @Expose
	@Nullable
    public Boolean v5_0;

    /**
     * The V5_1.
     * Version 5.1 or later.
     */
    @SerializedName(value = "v5_1", alternate = {"V5_1"})
    @Expose
	@Nullable
    public Boolean v5_1;

    /**
     * The V6_0.
     * Version 6.0 or later.
     */
    @SerializedName(value = "v6_0", alternate = {"V6_0"})
    @Expose
	@Nullable
    public Boolean v6_0;

    /**
     * The V7_0.
     * Version 7.0 or later.
     */
    @SerializedName(value = "v7_0", alternate = {"V7_0"})
    @Expose
	@Nullable
    public Boolean v7_0;

    /**
     * The V7_1.
     * Version 7.1 or later.
     */
    @SerializedName(value = "v7_1", alternate = {"V7_1"})
    @Expose
	@Nullable
    public Boolean v7_1;

    /**
     * The V8_0.
     * Version 8.0 or later.
     */
    @SerializedName(value = "v8_0", alternate = {"V8_0"})
    @Expose
	@Nullable
    public Boolean v8_0;

    /**
     * The V8_1.
     * Version 8.1 or later.
     */
    @SerializedName(value = "v8_1", alternate = {"V8_1"})
    @Expose
	@Nullable
    public Boolean v8_1;

    /**
     * The V9_0.
     * Version 9.0 or later.
     */
    @SerializedName(value = "v9_0", alternate = {"V9_0"})
    @Expose
	@Nullable
    public Boolean v9_0;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
