// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Filter Apply Custom Filter Parameter Set.
 */
public class WorkbookFilterApplyCustomFilterParameterSet {
    /**
     * The criteria1.
     * 
     */
    @SerializedName(value = "criteria1", alternate = {"Criteria1"})
    @Expose
	@Nullable
    public String criteria1;

    /**
     * The criteria2.
     * 
     */
    @SerializedName(value = "criteria2", alternate = {"Criteria2"})
    @Expose
	@Nullable
    public String criteria2;

    /**
     * The oper.
     * 
     */
    @SerializedName(value = "oper", alternate = {"Oper"})
    @Expose
	@Nullable
    public String oper;


    /**
     * Instiaciates a new WorkbookFilterApplyCustomFilterParameterSet
     */
    public WorkbookFilterApplyCustomFilterParameterSet() {}
    /**
     * Instiaciates a new WorkbookFilterApplyCustomFilterParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFilterApplyCustomFilterParameterSet(@Nonnull final WorkbookFilterApplyCustomFilterParameterSetBuilder builder) {
        this.criteria1 = builder.criteria1;
        this.criteria2 = builder.criteria2;
        this.oper = builder.oper;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFilterApplyCustomFilterParameterSetBuilder newBuilder() {
        return new WorkbookFilterApplyCustomFilterParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFilterApplyCustomFilterParameterSet
     */
    public static final class WorkbookFilterApplyCustomFilterParameterSetBuilder {
        /**
         * The criteria1 parameter value
         */
        @Nullable
        protected String criteria1;
        /**
         * Sets the Criteria1
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFilterApplyCustomFilterParameterSetBuilder withCriteria1(@Nullable final String val) {
            this.criteria1 = val;
            return this;
        }
        /**
         * The criteria2 parameter value
         */
        @Nullable
        protected String criteria2;
        /**
         * Sets the Criteria2
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFilterApplyCustomFilterParameterSetBuilder withCriteria2(@Nullable final String val) {
            this.criteria2 = val;
            return this;
        }
        /**
         * The oper parameter value
         */
        @Nullable
        protected String oper;
        /**
         * Sets the Oper
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFilterApplyCustomFilterParameterSetBuilder withOper(@Nullable final String val) {
            this.oper = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFilterApplyCustomFilterParameterSetBuilder
         */
        @Nullable
        protected WorkbookFilterApplyCustomFilterParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFilterApplyCustomFilterParameterSet build() {
            return new WorkbookFilterApplyCustomFilterParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.criteria1 != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("criteria1", criteria1));
        }
        if(this.criteria2 != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("criteria2", criteria2));
        }
        if(this.oper != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("oper", oper));
        }
        return result;
    }
}
