// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Atan2Parameter Set.
 */
public class WorkbookFunctionsAtan2ParameterSet {
    /**
     * The x Num.
     * 
     */
    @SerializedName(value = "xNum", alternate = {"XNum"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement xNum;

    /**
     * The y Num.
     * 
     */
    @SerializedName(value = "yNum", alternate = {"YNum"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement yNum;


    /**
     * Instiaciates a new WorkbookFunctionsAtan2ParameterSet
     */
    public WorkbookFunctionsAtan2ParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsAtan2ParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsAtan2ParameterSet(@Nonnull final WorkbookFunctionsAtan2ParameterSetBuilder builder) {
        this.xNum = builder.xNum;
        this.yNum = builder.yNum;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsAtan2ParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsAtan2ParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsAtan2ParameterSet
     */
    public static final class WorkbookFunctionsAtan2ParameterSetBuilder {
        /**
         * The xNum parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement xNum;
        /**
         * Sets the XNum
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsAtan2ParameterSetBuilder withXNum(@Nullable final com.google.gson.JsonElement val) {
            this.xNum = val;
            return this;
        }
        /**
         * The yNum parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement yNum;
        /**
         * Sets the YNum
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsAtan2ParameterSetBuilder withYNum(@Nullable final com.google.gson.JsonElement val) {
            this.yNum = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsAtan2ParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsAtan2ParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsAtan2ParameterSet build() {
            return new WorkbookFunctionsAtan2ParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.xNum != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("xNum", xNum));
        }
        if(this.yNum != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("yNum", yNum));
        }
        return result;
    }
}
