/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.MobileLobApp;
import com.microsoft.graph.models.Win32LobAppInstallExperience;
import com.microsoft.graph.models.Win32LobAppMsiInformation;
import com.microsoft.graph.models.Win32LobAppReturnCode;
import com.microsoft.graph.models.Win32LobAppRule;
import com.microsoft.graph.models.WindowsArchitecture;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Win32LobApp
extends MobileLobApp
implements Parsable {
    public Win32LobApp() {
        this.setOdataType("#microsoft.graph.win32LobApp");
    }

    @Nonnull
    public static Win32LobApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Win32LobApp();
    }

    @Nullable
    public EnumSet<WindowsArchitecture> getApplicableArchitectures() {
        return (EnumSet)this.backingStore.get("applicableArchitectures");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("applicableArchitectures", n -> this.setApplicableArchitectures(n.getEnumSetValue(WindowsArchitecture::forValue)));
        deserializerMap.put("installCommandLine", n -> this.setInstallCommandLine(n.getStringValue()));
        deserializerMap.put("installExperience", n -> this.setInstallExperience((Win32LobAppInstallExperience)n.getObjectValue(Win32LobAppInstallExperience::createFromDiscriminatorValue)));
        deserializerMap.put("minimumCpuSpeedInMHz", n -> this.setMinimumCpuSpeedInMHz(n.getIntegerValue()));
        deserializerMap.put("minimumFreeDiskSpaceInMB", n -> this.setMinimumFreeDiskSpaceInMB(n.getIntegerValue()));
        deserializerMap.put("minimumMemoryInMB", n -> this.setMinimumMemoryInMB(n.getIntegerValue()));
        deserializerMap.put("minimumNumberOfProcessors", n -> this.setMinimumNumberOfProcessors(n.getIntegerValue()));
        deserializerMap.put("minimumSupportedWindowsRelease", n -> this.setMinimumSupportedWindowsRelease(n.getStringValue()));
        deserializerMap.put("msiInformation", n -> this.setMsiInformation((Win32LobAppMsiInformation)n.getObjectValue(Win32LobAppMsiInformation::createFromDiscriminatorValue)));
        deserializerMap.put("returnCodes", n -> this.setReturnCodes(n.getCollectionOfObjectValues(Win32LobAppReturnCode::createFromDiscriminatorValue)));
        deserializerMap.put("rules", n -> this.setRules(n.getCollectionOfObjectValues(Win32LobAppRule::createFromDiscriminatorValue)));
        deserializerMap.put("setupFilePath", n -> this.setSetupFilePath(n.getStringValue()));
        deserializerMap.put("uninstallCommandLine", n -> this.setUninstallCommandLine(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getInstallCommandLine() {
        return (String)this.backingStore.get("installCommandLine");
    }

    @Nullable
    public Win32LobAppInstallExperience getInstallExperience() {
        return (Win32LobAppInstallExperience)this.backingStore.get("installExperience");
    }

    @Nullable
    public Integer getMinimumCpuSpeedInMHz() {
        return (Integer)this.backingStore.get("minimumCpuSpeedInMHz");
    }

    @Nullable
    public Integer getMinimumFreeDiskSpaceInMB() {
        return (Integer)this.backingStore.get("minimumFreeDiskSpaceInMB");
    }

    @Nullable
    public Integer getMinimumMemoryInMB() {
        return (Integer)this.backingStore.get("minimumMemoryInMB");
    }

    @Nullable
    public Integer getMinimumNumberOfProcessors() {
        return (Integer)this.backingStore.get("minimumNumberOfProcessors");
    }

    @Nullable
    public String getMinimumSupportedWindowsRelease() {
        return (String)this.backingStore.get("minimumSupportedWindowsRelease");
    }

    @Nullable
    public Win32LobAppMsiInformation getMsiInformation() {
        return (Win32LobAppMsiInformation)this.backingStore.get("msiInformation");
    }

    @Nullable
    public List<Win32LobAppReturnCode> getReturnCodes() {
        return (List)this.backingStore.get("returnCodes");
    }

    @Nullable
    public List<Win32LobAppRule> getRules() {
        return (List)this.backingStore.get("rules");
    }

    @Nullable
    public String getSetupFilePath() {
        return (String)this.backingStore.get("setupFilePath");
    }

    @Nullable
    public String getUninstallCommandLine() {
        return (String)this.backingStore.get("uninstallCommandLine");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumSetValue("applicableArchitectures", this.getApplicableArchitectures());
        writer.writeStringValue("installCommandLine", this.getInstallCommandLine());
        writer.writeObjectValue("installExperience", (Parsable)this.getInstallExperience(), new Parsable[0]);
        writer.writeIntegerValue("minimumCpuSpeedInMHz", this.getMinimumCpuSpeedInMHz());
        writer.writeIntegerValue("minimumFreeDiskSpaceInMB", this.getMinimumFreeDiskSpaceInMB());
        writer.writeIntegerValue("minimumMemoryInMB", this.getMinimumMemoryInMB());
        writer.writeIntegerValue("minimumNumberOfProcessors", this.getMinimumNumberOfProcessors());
        writer.writeStringValue("minimumSupportedWindowsRelease", this.getMinimumSupportedWindowsRelease());
        writer.writeObjectValue("msiInformation", (Parsable)this.getMsiInformation(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("returnCodes", this.getReturnCodes());
        writer.writeCollectionOfObjectValues("rules", this.getRules());
        writer.writeStringValue("setupFilePath", this.getSetupFilePath());
        writer.writeStringValue("uninstallCommandLine", this.getUninstallCommandLine());
    }

    public void setApplicableArchitectures(@Nullable EnumSet<WindowsArchitecture> value) {
        this.backingStore.set("applicableArchitectures", value);
    }

    public void setInstallCommandLine(@Nullable String value) {
        this.backingStore.set("installCommandLine", (Object)value);
    }

    public void setInstallExperience(@Nullable Win32LobAppInstallExperience value) {
        this.backingStore.set("installExperience", (Object)value);
    }

    public void setMinimumCpuSpeedInMHz(@Nullable Integer value) {
        this.backingStore.set("minimumCpuSpeedInMHz", (Object)value);
    }

    public void setMinimumFreeDiskSpaceInMB(@Nullable Integer value) {
        this.backingStore.set("minimumFreeDiskSpaceInMB", (Object)value);
    }

    public void setMinimumMemoryInMB(@Nullable Integer value) {
        this.backingStore.set("minimumMemoryInMB", (Object)value);
    }

    public void setMinimumNumberOfProcessors(@Nullable Integer value) {
        this.backingStore.set("minimumNumberOfProcessors", (Object)value);
    }

    public void setMinimumSupportedWindowsRelease(@Nullable String value) {
        this.backingStore.set("minimumSupportedWindowsRelease", (Object)value);
    }

    public void setMsiInformation(@Nullable Win32LobAppMsiInformation value) {
        this.backingStore.set("msiInformation", (Object)value);
    }

    public void setReturnCodes(@Nullable List<Win32LobAppReturnCode> value) {
        this.backingStore.set("returnCodes", value);
    }

    public void setRules(@Nullable List<Win32LobAppRule> value) {
        this.backingStore.set("rules", value);
    }

    public void setSetupFilePath(@Nullable String value) {
        this.backingStore.set("setupFilePath", (Object)value);
    }

    public void setUninstallCommandLine(@Nullable String value) {
        this.backingStore.set("uninstallCommandLine", (Object)value);
    }
}

