/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DlpActionInfo;
import com.microsoft.graph.models.ProcessingError;
import com.microsoft.graph.models.ProtectionScopeState;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProcessContentResponse
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ProcessContentResponse() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ProcessContentResponse createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ProcessContentResponse();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("policyActions", n -> this.setPolicyActions(n.getCollectionOfObjectValues(DlpActionInfo::createFromDiscriminatorValue)));
        deserializerMap.put("processingErrors", n -> this.setProcessingErrors(n.getCollectionOfObjectValues(ProcessingError::createFromDiscriminatorValue)));
        deserializerMap.put("protectionScopeState", n -> this.setProtectionScopeState((ProtectionScopeState)n.getEnumValue(ProtectionScopeState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<DlpActionInfo> getPolicyActions() {
        return (List)this.backingStore.get("policyActions");
    }

    @Nullable
    public List<ProcessingError> getProcessingErrors() {
        return (List)this.backingStore.get("processingErrors");
    }

    @Nullable
    public ProtectionScopeState getProtectionScopeState() {
        return (ProtectionScopeState)((Object)this.backingStore.get("protectionScopeState"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("policyActions", this.getPolicyActions());
        writer.writeCollectionOfObjectValues("processingErrors", this.getProcessingErrors());
        writer.writeEnumValue("protectionScopeState", (Enum)this.getProtectionScopeState());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPolicyActions(@Nullable List<DlpActionInfo> value) {
        this.backingStore.set("policyActions", value);
    }

    public void setProcessingErrors(@Nullable List<ProcessingError> value) {
        this.backingStore.set("processingErrors", value);
    }

    public void setProtectionScopeState(@Nullable ProtectionScopeState value) {
        this.backingStore.set("protectionScopeState", (Object)value);
    }
}

