/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DriveProtectionUnit;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.MailboxProtectionUnit;
import com.microsoft.graph.models.ProtectionSource;
import com.microsoft.graph.models.ProtectionUnitStatus;
import com.microsoft.graph.models.PublicError;
import com.microsoft.graph.models.SiteProtectionUnit;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProtectionUnitBase
extends Entity
implements Parsable {
    @Nonnull
    public static ProtectionUnitBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.driveProtectionUnit": {
                    return new DriveProtectionUnit();
                }
                case "#microsoft.graph.mailboxProtectionUnit": {
                    return new MailboxProtectionUnit();
                }
                case "#microsoft.graph.siteProtectionUnit": {
                    return new SiteProtectionUnit();
                }
            }
        }
        return new ProtectionUnitBase();
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public PublicError getError() {
        return (PublicError)this.backingStore.get("error");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("error", n -> this.setError((PublicError)n.getObjectValue(PublicError::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("offboardRequestedDateTime", n -> this.setOffboardRequestedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("policyId", n -> this.setPolicyId(n.getStringValue()));
        deserializerMap.put("protectionSources", n -> this.setProtectionSources(n.getEnumSetValue(ProtectionSource::forValue)));
        deserializerMap.put("status", n -> this.setStatus((ProtectionUnitStatus)n.getEnumValue(ProtectionUnitStatus::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public OffsetDateTime getOffboardRequestedDateTime() {
        return (OffsetDateTime)this.backingStore.get("offboardRequestedDateTime");
    }

    @Nullable
    public String getPolicyId() {
        return (String)this.backingStore.get("policyId");
    }

    @Nullable
    public EnumSet<ProtectionSource> getProtectionSources() {
        return (EnumSet)this.backingStore.get("protectionSources");
    }

    @Nullable
    public ProtectionUnitStatus getStatus() {
        return (ProtectionUnitStatus)((Object)this.backingStore.get("status"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeOffsetDateTimeValue("offboardRequestedDateTime", this.getOffboardRequestedDateTime());
        writer.writeStringValue("policyId", this.getPolicyId());
        writer.writeEnumSetValue("protectionSources", this.getProtectionSources());
        writer.writeEnumValue("status", (Enum)this.getStatus());
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setError(@Nullable PublicError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setOffboardRequestedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("offboardRequestedDateTime", (Object)value);
    }

    public void setPolicyId(@Nullable String value) {
        this.backingStore.set("policyId", (Object)value);
    }

    public void setProtectionSources(@Nullable EnumSet<ProtectionSource> value) {
        this.backingStore.set("protectionSources", value);
    }

    public void setStatus(@Nullable ProtectionUnitStatus value) {
        this.backingStore.set("status", (Object)value);
    }
}

