/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.AntispamTeamsDirection;
import com.microsoft.graph.models.security.FileEvidence;
import com.microsoft.graph.models.security.TeamsDeliveryLocation;
import com.microsoft.graph.models.security.TeamsMessageDeliveryAction;
import com.microsoft.graph.models.security.UrlEvidence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class TeamsMessageEvidence
extends AlertEvidence
implements Parsable {
    public TeamsMessageEvidence() {
        this.setOdataType("#microsoft.graph.security.teamsMessageEvidence");
    }

    @Nonnull
    public static TeamsMessageEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TeamsMessageEvidence();
    }

    @Nullable
    public String getCampaignId() {
        return (String)this.backingStore.get("campaignId");
    }

    @Nullable
    public String getChannelId() {
        return (String)this.backingStore.get("channelId");
    }

    @Nullable
    public TeamsMessageDeliveryAction getDeliveryAction() {
        return (TeamsMessageDeliveryAction)((Object)this.backingStore.get("deliveryAction"));
    }

    @Nullable
    public TeamsDeliveryLocation getDeliveryLocation() {
        return (TeamsDeliveryLocation)((Object)this.backingStore.get("deliveryLocation"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("campaignId", n -> this.setCampaignId(n.getStringValue()));
        deserializerMap.put("channelId", n -> this.setChannelId(n.getStringValue()));
        deserializerMap.put("deliveryAction", n -> this.setDeliveryAction((TeamsMessageDeliveryAction)n.getEnumValue(TeamsMessageDeliveryAction::forValue)));
        deserializerMap.put("deliveryLocation", n -> this.setDeliveryLocation((TeamsDeliveryLocation)n.getEnumValue(TeamsDeliveryLocation::forValue)));
        deserializerMap.put("files", n -> this.setFiles(n.getCollectionOfObjectValues(FileEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("groupId", n -> this.setGroupId(n.getStringValue()));
        deserializerMap.put("isExternal", n -> this.setIsExternal(n.getBooleanValue()));
        deserializerMap.put("isOwned", n -> this.setIsOwned(n.getBooleanValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("messageDirection", n -> this.setMessageDirection((AntispamTeamsDirection)n.getEnumValue(AntispamTeamsDirection::forValue)));
        deserializerMap.put("messageId", n -> this.setMessageId(n.getStringValue()));
        deserializerMap.put("owningTenantId", n -> this.setOwningTenantId(n.getUUIDValue()));
        deserializerMap.put("parentMessageId", n -> this.setParentMessageId(n.getStringValue()));
        deserializerMap.put("receivedDateTime", n -> this.setReceivedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("recipients", n -> this.setRecipients(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("senderFromAddress", n -> this.setSenderFromAddress(n.getStringValue()));
        deserializerMap.put("senderIP", n -> this.setSenderIP(n.getStringValue()));
        deserializerMap.put("sourceAppName", n -> this.setSourceAppName(n.getStringValue()));
        deserializerMap.put("sourceId", n -> this.setSourceId(n.getStringValue()));
        deserializerMap.put("subject", n -> this.setSubject(n.getStringValue()));
        deserializerMap.put("suspiciousRecipients", n -> this.setSuspiciousRecipients(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("threadId", n -> this.setThreadId(n.getStringValue()));
        deserializerMap.put("threadType", n -> this.setThreadType(n.getStringValue()));
        deserializerMap.put("urls", n -> this.setUrls(n.getCollectionOfObjectValues(UrlEvidence::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<FileEvidence> getFiles() {
        return (List)this.backingStore.get("files");
    }

    @Nullable
    public String getGroupId() {
        return (String)this.backingStore.get("groupId");
    }

    @Nullable
    public Boolean getIsExternal() {
        return (Boolean)this.backingStore.get("isExternal");
    }

    @Nullable
    public Boolean getIsOwned() {
        return (Boolean)this.backingStore.get("isOwned");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public AntispamTeamsDirection getMessageDirection() {
        return (AntispamTeamsDirection)((Object)this.backingStore.get("messageDirection"));
    }

    @Nullable
    public String getMessageId() {
        return (String)this.backingStore.get("messageId");
    }

    @Nullable
    public UUID getOwningTenantId() {
        return (UUID)this.backingStore.get("owningTenantId");
    }

    @Nullable
    public String getParentMessageId() {
        return (String)this.backingStore.get("parentMessageId");
    }

    @Nullable
    public OffsetDateTime getReceivedDateTime() {
        return (OffsetDateTime)this.backingStore.get("receivedDateTime");
    }

    @Nullable
    public List<String> getRecipients() {
        return (List)this.backingStore.get("recipients");
    }

    @Nullable
    public String getSenderFromAddress() {
        return (String)this.backingStore.get("senderFromAddress");
    }

    @Nullable
    public String getSenderIP() {
        return (String)this.backingStore.get("senderIP");
    }

    @Nullable
    public String getSourceAppName() {
        return (String)this.backingStore.get("sourceAppName");
    }

    @Nullable
    public String getSourceId() {
        return (String)this.backingStore.get("sourceId");
    }

    @Nullable
    public String getSubject() {
        return (String)this.backingStore.get("subject");
    }

    @Nullable
    public List<String> getSuspiciousRecipients() {
        return (List)this.backingStore.get("suspiciousRecipients");
    }

    @Nullable
    public String getThreadId() {
        return (String)this.backingStore.get("threadId");
    }

    @Nullable
    public String getThreadType() {
        return (String)this.backingStore.get("threadType");
    }

    @Nullable
    public List<UrlEvidence> getUrls() {
        return (List)this.backingStore.get("urls");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("campaignId", this.getCampaignId());
        writer.writeStringValue("channelId", this.getChannelId());
        writer.writeEnumValue("deliveryAction", (Enum)this.getDeliveryAction());
        writer.writeEnumValue("deliveryLocation", (Enum)this.getDeliveryLocation());
        writer.writeCollectionOfObjectValues("files", this.getFiles());
        writer.writeStringValue("groupId", this.getGroupId());
        writer.writeBooleanValue("isExternal", this.getIsExternal());
        writer.writeBooleanValue("isOwned", this.getIsOwned());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeEnumValue("messageDirection", (Enum)this.getMessageDirection());
        writer.writeStringValue("messageId", this.getMessageId());
        writer.writeUUIDValue("owningTenantId", this.getOwningTenantId());
        writer.writeStringValue("parentMessageId", this.getParentMessageId());
        writer.writeOffsetDateTimeValue("receivedDateTime", this.getReceivedDateTime());
        writer.writeCollectionOfPrimitiveValues("recipients", this.getRecipients());
        writer.writeStringValue("senderFromAddress", this.getSenderFromAddress());
        writer.writeStringValue("senderIP", this.getSenderIP());
        writer.writeStringValue("sourceAppName", this.getSourceAppName());
        writer.writeStringValue("sourceId", this.getSourceId());
        writer.writeStringValue("subject", this.getSubject());
        writer.writeCollectionOfPrimitiveValues("suspiciousRecipients", this.getSuspiciousRecipients());
        writer.writeStringValue("threadId", this.getThreadId());
        writer.writeStringValue("threadType", this.getThreadType());
        writer.writeCollectionOfObjectValues("urls", this.getUrls());
    }

    public void setCampaignId(@Nullable String value) {
        this.backingStore.set("campaignId", (Object)value);
    }

    public void setChannelId(@Nullable String value) {
        this.backingStore.set("channelId", (Object)value);
    }

    public void setDeliveryAction(@Nullable TeamsMessageDeliveryAction value) {
        this.backingStore.set("deliveryAction", (Object)value);
    }

    public void setDeliveryLocation(@Nullable TeamsDeliveryLocation value) {
        this.backingStore.set("deliveryLocation", (Object)value);
    }

    public void setFiles(@Nullable List<FileEvidence> value) {
        this.backingStore.set("files", value);
    }

    public void setGroupId(@Nullable String value) {
        this.backingStore.set("groupId", (Object)value);
    }

    public void setIsExternal(@Nullable Boolean value) {
        this.backingStore.set("isExternal", (Object)value);
    }

    public void setIsOwned(@Nullable Boolean value) {
        this.backingStore.set("isOwned", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setMessageDirection(@Nullable AntispamTeamsDirection value) {
        this.backingStore.set("messageDirection", (Object)value);
    }

    public void setMessageId(@Nullable String value) {
        this.backingStore.set("messageId", (Object)value);
    }

    public void setOwningTenantId(@Nullable UUID value) {
        this.backingStore.set("owningTenantId", (Object)value);
    }

    public void setParentMessageId(@Nullable String value) {
        this.backingStore.set("parentMessageId", (Object)value);
    }

    public void setReceivedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("receivedDateTime", (Object)value);
    }

    public void setRecipients(@Nullable List<String> value) {
        this.backingStore.set("recipients", value);
    }

    public void setSenderFromAddress(@Nullable String value) {
        this.backingStore.set("senderFromAddress", (Object)value);
    }

    public void setSenderIP(@Nullable String value) {
        this.backingStore.set("senderIP", (Object)value);
    }

    public void setSourceAppName(@Nullable String value) {
        this.backingStore.set("sourceAppName", (Object)value);
    }

    public void setSourceId(@Nullable String value) {
        this.backingStore.set("sourceId", (Object)value);
    }

    public void setSubject(@Nullable String value) {
        this.backingStore.set("subject", (Object)value);
    }

    public void setSuspiciousRecipients(@Nullable List<String> value) {
        this.backingStore.set("suspiciousRecipients", value);
    }

    public void setThreadId(@Nullable String value) {
        this.backingStore.set("threadId", (Object)value);
    }

    public void setThreadType(@Nullable String value) {
        this.backingStore.set("threadType", (Object)value);
    }

    public void setUrls(@Nullable List<UrlEvidence> value) {
        this.backingStore.set("urls", value);
    }
}

