/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class SerializationWriterProxyFactory
implements SerializationWriterFactory {
    private final SerializationWriterFactory _concrete;
    private final Consumer<Parsable> _onBefore;
    private final Consumer<Parsable> _onAfter;
    private final BiConsumer<Parsable, SerializationWriter> _onStart;

    @Override
    @Nonnull
    public String getValidContentType() {
        return this._concrete.getValidContentType();
    }

    public SerializationWriterProxyFactory(@Nonnull SerializationWriterFactory concrete, @Nullable Consumer<Parsable> onBeforeSerialization, @Nullable Consumer<Parsable> onAfterSerialization, @Nullable BiConsumer<Parsable, SerializationWriter> onStartObjectSerialization) {
        this._concrete = Objects.requireNonNull(concrete);
        this._onBefore = onBeforeSerialization;
        this._onAfter = onAfterSerialization;
        this._onStart = onStartObjectSerialization;
    }

    @Override
    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType) {
        SerializationWriter writer = this._concrete.getSerializationWriter(contentType);
        Consumer<Parsable> originalBefore = writer.getOnBeforeObjectSerialization();
        Consumer<Parsable> originalAfter = writer.getOnAfterObjectSerialization();
        BiConsumer<Parsable, SerializationWriter> originalStart = writer.getOnStartObjectSerialization();
        writer.setOnBeforeObjectSerialization(x -> {
            if (this._onBefore != null) {
                this._onBefore.accept((Parsable)x);
            }
            if (originalBefore != null) {
                originalBefore.accept((Parsable)x);
            }
        });
        writer.setOnAfterObjectSerialization(x -> {
            if (this._onAfter != null) {
                this._onAfter.accept((Parsable)x);
            }
            if (originalAfter != null) {
                originalAfter.accept((Parsable)x);
            }
        });
        writer.setOnStartObjectSerialization((x, y) -> {
            if (this._onStart != null) {
                this._onStart.accept((Parsable)x, (SerializationWriter)y);
            }
            if (originalStart != null) {
                originalStart.accept((Parsable)x, (SerializationWriter)y);
            }
        });
        return writer;
    }
}

