/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.authentication;

import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class AllowedHostsValidator {
    private HashSet<String> validHosts;

    public AllowedHostsValidator(String ... allowedHosts) {
        HashSet<String> value = new HashSet<String>(allowedHosts.length);
        for (String val : allowedHosts) {
            value.add(val);
        }
        this.setAllowedHosts(value);
    }

    @Nonnull
    public Set<String> getAllowedHosts() {
        return Collections.unmodifiableSet(this.validHosts);
    }

    public void setAllowedHosts(@Nonnull Set<String> allowedHosts) {
        this.validHosts = new HashSet();
        if (allowedHosts != null) {
            for (String host : allowedHosts) {
                if (host == null || host.isEmpty()) continue;
                if ((host = host.trim().toLowerCase(Locale.ROOT)).startsWith("http://") || host.startsWith("https://")) {
                    throw new IllegalArgumentException("host should not contain http or https prefix");
                }
                this.validHosts.add(host);
            }
        }
    }

    public boolean isUrlHostValid(@Nonnull URI uri) {
        return this.validHosts.isEmpty() || this.validHosts.contains(uri.getHost().trim().toLowerCase(Locale.ROOT));
    }
}

