package nl.oostnl.ventureplan.jobs.dynamics;

import java.net.MalformedURLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;

import nl.buildersenperformers.xam.engine.OperationException;

public class AzureLogin {
	//Azure Application Client ID
	private String iClientId = null;
	private String iClientSecret = null;
	//CRM URL
	private String iResource = null;
	//O365 credentials for authentication w/o login prompt
	//Azure Directory OAUTH 2.0 AUTHORIZATION ENDPOINT
	private String iAuthority = null; 

	/**
	 * @param pClientId Azure Application Client ID
	 * @param pClientSecret Azure Application Client Secret
	 * @param pResource Azure resource url
	 * @param pAuthority Azure Directory OAUTH 2.0 AUTHORIZATION ENDPOINT
	 */
	public AzureLogin(String pClientId, String pClientSecret, String pResource, String pAuthority) {
		super();
		iClientId = pClientId;
		iClientSecret = pClientSecret;
		iResource = pResource;
		iAuthority = pAuthority;
	}

	public String getToken() throws OperationException {
	
		AuthenticationContext context = null;
		AuthenticationResult result = null;
		ExecutorService service = null;
		ClientCredential cred= new ClientCredential(iClientId, iClientSecret);
		try {
		    service = Executors.newFixedThreadPool(1);
		    context = new AuthenticationContext(iAuthority, false, service);
		    Future<AuthenticationResult> future = context.acquireToken(iResource,
		            cred, null);
		    result = future.get();
		} catch (MalformedURLException | InterruptedException | ExecutionException e) {
			throw new OperationException("Could not login",e);
		} finally {
			if (service!=null){
				service.shutdown();
			}
		}
	
		return result.getAccessToken();
	}

}