package nl.oostnl.ventureplan.jobs.export;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Properties;

public class ExportDataset  implements Dataset{
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(ExportDataset.class);
	
	private Properties iProperties;

	public ExportDataset() {
		/* nothin for now*/
	}

	@Override
	public Operation getCreate() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public Operation getRead() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public Operation getUpdate() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public Operation getDelete() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public Operation getList() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public List<String> listOperations() {
		List<String> lRetVal=new ArrayList<>();
		lRetVal.add("ListDiffDocstore");
		lRetVal.add("ListDiffLargeText");
		return lRetVal;
	}

	@Override
	public Operation getOperation(String pOperation) throws OperationException {
		Operation lOperation=null;
		switch(pOperation){
		case "ListDiffDocstore":
			lOperation=new ListDiffDocstore();lOperation.setProperties(iProperties);break;
		case "ListDiffLargeText":
			lOperation=new ListDiffLargeText();lOperation.setProperties(iProperties);break;
		default: lOperation=null;
		}
		return lOperation;
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;
		
	}

	@Override
	public String getDescription() {
		return "Dataset voor diverse exports";
	}

	@Override
	public String getDocumentation() {
		ClassLoader classLoader = getClass().getClassLoader();
		InputStream lDocStream=classLoader.getResourceAsStream("export/documentation.md");
		try {
			return IOUtil.toString(lDocStream);
		} catch (IOException e) {
			log4j.error("Could not get documentation",e);
		}
		return null;
	}

}
