package nl.oostnl.ventureplan.jobs.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Properties;

public class ListDiffLargeText implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.3 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(ListDiffDocstore.class);
	private Properties iProperties;
	private Map<String,Object> iParams;
	
	private XamEngine iXE=null;
	private Dataset iDsAnswers=null;
	private Dataset iDataset;
	
	public ListDiffLargeText() {
		super();
		iXE = new XamEngine();
		try {
			iDsAnswers = iXE.getDataset("Documents");
		} catch (DatasetException e) {
			throw new RuntimeException(e);
		}
		
		iParams=new HashMap<>();
	}

	@Override
	public Operator getOperator(String pName) {
		/* nothin for now*/
		return null;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);

	}

	@Override
	public void setParameter(String pName, List<Object> pValue) {
		/* nothin for now*/
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean supportsResultset() {
		return false;
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {

		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		List<Map<String, Object>> lRetVal=new ArrayList<>();
		
		String lProc="Diff van documents";
		PROCESS_LOGGER.start(lProc);
		
		Operation lListDocs=iDsAnswers.getOperation("ListLargeText");
		lListDocs.setParameter("intake_answer_id", new Integer((String)iParams.get("intake_answer_id")));
		ResultSet lResAnswer=lListDocs.executeAsResultset();
		
		String lTextBase=ConfigurationProperties.get().get("DD_TEXT_FILE_PATH");
		FileWriter lWriter=null;
		BufferedWriter lBWriter=null;
		try {
			lWriter=new FileWriter((String) iParams.get("resultFile"));
			lBWriter=new BufferedWriter(lWriter);
		} catch (IOException e1) {
			throw new OperationException(e1);
		}
		
		try {
			while (lResAnswer.next()){
				String file= "" + lResAnswer.getInt("intake_answer_file") + "_xam_intake_answer";
				String path = lTextBase + file.substring(0, 1) + "/" + file.substring(1,2) + "/" + file;
				File locFile=new File(path);
				
				if (locFile.exists()){
					lBWriter.write(relativePath(lTextBase, path));
					lBWriter.newLine();
				}
			}
			lBWriter.close();
			lWriter.close();
		} catch (SQLException | IOException  e) {
			if (iParams.containsKey("logFileErrors")){
				log4j.warn("Error getting file",e);
				
			}
		}
		
		PROCESS_LOGGER.complete(lProc);		
		return null;
	}

	@Override
	public void close() {
		/* nothin for now*/
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;

	}

	@Override
	public void setDataset(Dataset pDataset) {
		iDataset=pDataset;

	}

	@Override
	public String getDescription() {
		return "Exports large text";
	}

	private String relativePath(String pBase, String pPath){
		return new File(pBase).toURI().relativize(new File(pPath).toURI()).getPath();
	}

}
