/**
 * 
 */
package nl.oostnl.ventureplan.jobs.finfact;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.ListCellRenderer;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.groenfonds.jobs.interest.MonthylyInterestRevenueOperation;
import nl.knowledgeplaza.util.Properties;

/**
 * @author stpl
 * Send a daily report with missing finfacts in the journal log
 */
public class DailyFinfact implements Operation {
	public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(MonthylyInterestRevenueOperation.class);

	private static final String cRunDate = "rundate";

	private XamEngine iXE=null;
	private Dataset iFinFact;
	private Dataset iDataset;
	private Dataset iMedewerkers;
	private Map<String,Object> iParams;
	private Properties iProperties;
	
	/**
	 * constructor 
	 */
	public DailyFinfact() throws OperationException {
		iXE=new XamEngine();
		try {
			iFinFact=iXE.getDataset("FinFact");
			iMedewerkers=iXE.getDataset("Medewerker");
		} catch (DatasetException e) {
			throw new OperationException(e);
		}
		iParams=new HashMap<>();
	}
		

	/* (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#getOperator(java.lang.String)
	 */
	@Override
	public Operator getOperator(String pName) {
		return null;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#setParameter(java.lang.String, java.lang.Object)
	 */
	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);

	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#setParameter(java.lang.String, java.util.List)
	 */
	@Override
	public void setParameter(String pName, List<Object> pValue) {
		/* nothing for now*/
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#canExecute()
	 */
	@Override
	public boolean canExecute() {
		return true;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#supportsResultset()
	 */
	@Override
	public boolean supportsResultset() {
		return false;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#executeAsResultset()
	 */
	@Override
	public ResultSet executeAsResultset() throws OperationException {
		return null;
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#executeAsValueMap()
	 */
	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		return null;
	}

	/** (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#executeAsValueList()
	 */
	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		List<Map<String, Object>> lRetVal = new ArrayList<>();
		
		//check of er niet verwerkte finfacts zijn
		Operation lFFRegels = iFinFact.getOperation("CountFinfactErrors");
		lFFRegels.setParameter("rundate", iParams.get(cRunDate));
		ResultSet lRCRentes = lFFRegels.executeAsResultset();
		
		String lProc="Rapporteer niet verwerkte fin.feiten aangemaakt op: " + iParams.get(cRunDate);
		
		PROCESS_LOGGER.start(lProc);
		
		try {
			if (lRCRentes.next()) {
				
				log4j.info("Fouten gevonden: " + lRCRentes.getInt("aantal"));
				if (lRCRentes.getInt("aantal") > 0){
					//maak email voor controlling, medewerker beheer en coordinator IT
					List<String> lEmail=new ArrayList<>();
					
					Operation lMedewerkers =iMedewerkers.getOperation("ListMedewerker");
					lMedewerkers.setParameter("roles", "FB,CON");
					ResultSet lRSMedewerkers = lMedewerkers.executeAsResultset();
					while (lRSMedewerkers.next()){
						lEmail.add(lRSMedewerkers.getString("EMAILADDRESS"));
					}
					
					log4j.info("Stuur email naar: " + String.join(";", lEmail));
					Operation lSendEmail = iFinFact.getOperation("SendEmail");
					lSendEmail.setParameter("to", String.join(";", lEmail));
					lSendEmail.setParameter("rundate", iParams.get(cRunDate));
					lSendEmail.executeAsValueMap();
					
					//loop door regels heen en check of er mails naar medewerkers gestuurd moeten worden
					Operation lFinFactRows = iFinFact.getOperation("ListFinfactErrorMedewerker");
					lFinFactRows.setParameter("rundate", iParams.get(cRunDate));
					ResultSet lRSFinFactRows = lFinFactRows.executeAsResultset();
					
					//maak mails aan voor medewerkers
					while(lRSFinFactRows.next()){
						log4j.info("Stuur email naar: " + lRSFinFactRows.getString("EMAILADDRESS"));
						lSendEmail.setParameter("to", lRSFinFactRows.getString("EMAILADDRESS"));
						lSendEmail.setParameter("rundate", iParams.get(cRunDate));
						lSendEmail.setParameter("medewerker_id", lRSFinFactRows.getString("MEDEWERKER_ID"));
						lSendEmail.executeAsValueMap();
					}
				}
				
			}
			
			PROCESS_LOGGER.complete(lProc);
			return lRetVal;
		} catch (SQLException e) {
			throw new OperationException(e);
		}
	}

	/** (non-Javadoc)
	 * @see nl.buildersenperformers.xam.engine.Operation#close()
	 */
	@Override
	public void close() {
		/* nothing for now*/
	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#setProperties(nl.knowledgeplaza.util.Properties)
	 */
	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;

	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#setDataset(nl.buildersenperformers.xam.engine.Dataset)
	 */
	@Override
	public void setDataset(Dataset pDS) {
		iDataset = pDS;

	}

	/**
	 * @see nl.buildersenperformers.xam.engine.Operation#getDescription()
	 */
	@Override
	public String getDescription() {
		return "Send a daily report with missing finfacts in the journal log";
	}

}
