package nl.oostnl.ventureplan.jobs.finfact;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.groenfonds.jobs.interest.MonthylyInterestRevenueOperation;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Properties;
import nl.ppmoost.ventureplan2.servlets.TaskServlet;

public class GenerateFactuur implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(MonthylyInterestRevenueOperation.class);

	private static final String cRunDate = "rundate";
	private static final String cUserId = "user_id";
	private Dataset iDataset;
	private Map<String,Object> iParams;
	private Properties iProperties;
	private Dataset iDsFactuur=null;
	
	private XamEngine iXE=null;
	
	private HttpClient client; //stpl test: was static
	private static MultiThreadedHttpConnectionManager connMan;
	private String iLocalBase=null;
	private String iSession=null;
	
	private TaskServlet iTask=new TaskServlet();
	
	/**
	 * @throws OperationException 
	 * 
	 */
	public GenerateFactuur() throws OperationException {
		super();
		iXE=new XamEngine();
		iParams=new HashMap<>();
		try {
			iDsFactuur=iXE.getDataset("Factuur");
		} catch (DatasetException e) {
			throw new OperationException(e);
		}
		
		connMan = new MultiThreadedHttpConnectionManager();
		client= new HttpClient(connMan);
		
		iLocalBase = ConfigurationProperties.get().get("LOCAL_BASE");
	}

	@Override
	public Operator getOperator(String pName) {
		return null;
	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);

	}

	@Override
	public void setParameter(String pName, List<Object> pValue) {

	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean supportsResultset() {
		return true;
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		PROCESS_LOGGER.start("Generate facturen", 1);
		
		Integer taskId=(Integer)iParams.get("task_id");
		
		httpLogin();

		//Haal alle leningen in beheer op 
		Operation lLeningdelen = iDsFactuur.getOperation("ListLeningDelen");
		lLeningdelen.setParameter("task_id", taskId);
		ResultSet lRCLening = lLeningdelen.executeAsResultset();
		
		try {
			while(lRCLening.next()){
				PROCESS_LOGGER.start("Generate Factuur voor lening: " + lRCLening.getString("FR_LENINGNR"), 2);
				
				if (lRCLening.getInt("has_templates")>0){
					//Maak taak om accountstatement te genereren
					int lTaskId=createVpTask(
								taskId,
								lRCLening.getInt("ORG_ID"),
								lRCLening.getInt("PROJ_ID"),
								lRCLening.getInt("FR_ID"),
								lRCLening.getInt("MEDEWERKER_ID"),
								lRCLening.getInt("NOTA_ID"),
								lRCLening.getString("RUNDATE"),
								lRCLening.getString("TEMPLATE_TYPE"),
								lRCLening.getString("FACTS"),
								lRCLening.getString("FACTUUR_NR")
					);
					
					//Voer de taak uit
					executeVpTask(lTaskId);
					
					PROCESS_LOGGER.complete("Generate Factuur voor lening: " + lRCLening.getString("FR_LENINGNR"), 2);
				} else {
					skipFactuur(taskId, lRCLening.getInt("NOTA_ID"));
					PROCESS_LOGGER.skip("Generate Factuur voor lening: " + lRCLening.getString("FR_LENINGNR"), 2);
				}
			}
			
			PROCESS_LOGGER.complete("Generate Account Statement", 1);
			return lRCLening;
		} catch (SQLException e) {
			String message="Error Generating Account Statement";
			log4j.error(message,e);
			throw new OperationException(message, e);
		} /*finally {
			httpLogout();
		}*/
	}

	private void httpLogin() throws OperationException {
		String lUser = ConfigurationProperties.get().get("Cheyenne.username");
		String lPassword = ConfigurationProperties.get().get("Cheyenne.password");
		
		String lUrl=iLocalBase + "/cheyenne?cddid=main&cmode=kpwindow_ventureplan";
		lUrl+="&_username=" + lUser + "&_passwd=" + lPassword;
		if (log4j.isDebugEnabled()) log4j.debug("Logging in with url: " + lUrl);
		
		GetMethod get = new GetMethod(lUrl);
		try {
			int statusCode = client.executeMethod(get);
			
			if (statusCode != HttpStatus.SC_OK) {
		        log4j.error("Method failed: " + get.getStatusLine());
		        String lContent=get.getResponseBodyAsString();
		        log4j.info("Method body: \n" + lContent);
		        throw new OperationException("Method failed: " + get.getStatusLine());
		        
		      }
			else {
				//check cookies
				HttpState state = client.getState();
				Cookie lCookies[] = state.getCookies();

				for (Cookie lCookie : lCookies)
				{
					if (lCookie.getName().equals("JSESSIONID"))
					{
						log4j.info("Got session id: " + lCookie.getValue());
						iSession = lCookie.getValue();
					}
				}				
			}
		} catch ( IOException e ) {
			String msg ="Error logging in"; 
			log4j.error(msg,e);
			throw new OperationException(msg,e);
		} 
		
	}

	private void httpLogout() throws OperationException {
		String lUser = ConfigurationProperties.get().get("Cheyenne.username");
		String lPassword = ConfigurationProperties.get().get("Cheyenne.password");
		
		String lUrl=iLocalBase + "/jsp/logout.jsp";
		if (log4j.isDebugEnabled()) log4j.debug("Logging out with url: " + lUrl);
		
		GetMethod get = new GetMethod(lUrl);
		try {
			int statusCode = client.executeMethod(get);
			
			if (statusCode != HttpStatus.SC_OK) {
		        log4j.error("Method failed: " + get.getStatusLine());
		        String lContent=get.getResponseBodyAsString();
		        log4j.info("Method body: \n" + lContent);
		        //throw new OperationException("Method failed: " + get.getStatusLine());
		        return;
		      }
		} catch ( IOException e ) {
			String msg ="Error logging in"; 
			log4j.error(msg,e);
			throw new OperationException(msg,e);
		} 
		
	}
	private void executeVpTask(int pTaskId) throws OperationException {
		/*String lUrl=iLocalBase + "/task?task_id=" + pTaskId + "&next_url=index.jsp";
		if (log4j.isDebugEnabled()) log4j.debug("Executing task with url: " + lUrl);
		
		GetMethod get = new GetMethod(lUrl);
		try {
			int statusCode = client.executeMethod(get);
			
			if (statusCode != HttpStatus.SC_OK) {
		        log4j.error("Method failed: " + get.getStatusLine());
		        String lContent=get.getResponseBodyAsString();
		        log4j.info("Method body: \n" + lContent);
		        throw new OperationException("Method failed: " + get.getStatusLine());
		        
		      }
		} catch ( IOException e ) {
			String msg ="Error logging in"; 
			log4j.error(msg,e);
			throw new OperationException(msg,e);
		}*/ 
		iTask.execute(pTaskId, null, iSession);
	}

	private int createVpTask(Integer pXamTaskId, int pOrgId, int pProjId, int pFrId,int pMedewerkerid,int pNotaId, String pRunDate, String templateType, String facts, String factuurNr) throws OperationException {
		Operation lCreateVpTask = iDsFactuur.getOperation("CreateVpTask");
		lCreateVpTask.setParameter("fr_id", Integer.valueOf(pFrId));
		lCreateVpTask.setParameter("medewerker_id", Integer.valueOf(pMedewerkerid));
		lCreateVpTask.setParameter("rundate", pRunDate);
		lCreateVpTask.setParameter("trxs", facts);
		lCreateVpTask.setParameter("template_type", templateType);
		if (factuurNr!=null){
			lCreateVpTask.setParameter("factuur_nr", factuurNr);
		}
		ResultSet lRCTask = lCreateVpTask.executeAsResultset();
		
		Operation lCreateWF = iDsFactuur.getOperation("CreateWF");
		Operation lUpdateWF = iDsFactuur.getOperation("UpdateWF");
		
		Operation lUpdateFactuur = iDsFactuur.getOperation("UpdateRecord");
		
		try {
			if (lRCTask.next()){
				int lWfwId=0;
				int lDocId=lRCTask.getInt("DOC_ID");
				
				if (iProperties.containsKey("useWF")){
					lCreateWF.setParameter("medewerker_id", pMedewerkerid);
					lCreateWF.setParameter("org_id", pOrgId);
					lCreateWF.setParameter("proj_id", pProjId);
					lCreateWF.setParameter("fr_id", pFrId);
					ResultSet lRSCreateWF=lCreateWF.executeAsResultset();
					
					lRSCreateWF.next();
					lWfwId=lRSCreateWF.getInt("P_WFW_ID");
					
					lUpdateWF.setParameter("wfw_id", lWfwId);
					lUpdateWF.setParameter("doc_id", lDocId);
					
					lUpdateWF.executeAsValueMap();
				}
				lUpdateFactuur.setParameter("task_id", pXamTaskId);
				lUpdateFactuur.setParameter("nota_id", Integer.valueOf(pNotaId));
				lUpdateFactuur.setParameter("wfw_id", Integer.valueOf(lWfwId));
				lUpdateFactuur.setParameter("doc_id", Integer.valueOf(lDocId));
				lUpdateFactuur.executeAsValueMap();
				
				return lRCTask.getInt("TASK_ID");
			}
		} catch (SQLException e) {
			String message="Error creating task";
			log4j.error(message,e);
			throw new OperationException(message, e);
		}
		
		return 0;
	}
	
	private void skipFactuur(int pXamTaskId, int pNotaId) throws OperationException{
		Operation lUpdateFactuur;
		try {
			lUpdateFactuur = iDsFactuur.getOperation("UpdateRecord");
			lUpdateFactuur.setParameter("task_id", pXamTaskId);
			lUpdateFactuur.setParameter("nota_id", Integer.valueOf(pNotaId));
			lUpdateFactuur.setParameter("wfw_id", Integer.valueOf(-1));
			lUpdateFactuur.setParameter("doc_id", Integer.valueOf(-1));
			lUpdateFactuur.executeAsValueMap();
		} catch (OperationException e) {
			String message="Error skipping factuur";
			log4j.error(message,e);
			throw new OperationException(message, e);
		}
		
		
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		ResultSet lResult = this.executeAsResultset();
		log4j.info("Resultset: " + lResult);
		return null;
	}

	@Override
	public void close() {

	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;
	}

	@Override
	public void setDataset(Dataset pDataset) {
		iDataset = pDataset;
	}

	@Override
	public String getDescription() {
		return "Creates the yeraly account statements";
	}

}
