package nl.oostnl.ventureplan.jobs.interest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.IOUtil;
import nl.knowledgeplaza.util.Properties;

public class InterestDataset implements Dataset {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	static private ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(InterestDataset.class);

	private Properties iProperties=null;
	
	public InterestDataset() {
		/* nothin for now*/
	}

	@Override
	public Operation getCreate() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public Operation getDelete() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public String getDescription() {
		return "Rente dataset";
	}

	@Override
	public String getDocumentation() {
		ClassLoader classLoader = getClass().getClassLoader();
		InputStream lDocStream=classLoader.getResourceAsStream("interest/documentation.md");
		try {
			return IOUtil.toString(lDocStream);
		} catch (IOException e) {
			log4j.error("Could not get documentation",e);
		}
		return null;	}

	@Override
	public Operation getList() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public Operation getOperation(String pOperation) throws OperationException {
		Operation lRet=null;
		switch(pOperation){
			case "MonthlyPremieRevenue": lRet= new MonthylyPremieRevenueOperation();lRet.setProperties(iProperties);break;
			case "YearlyPremie": lRet= new YearlyPremieOperation();lRet.setProperties(iProperties);break;
			default: lRet=null;
		}
		return lRet;
	}

	@Override
	public Operation getRead() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public Operation getUpdate() throws OperationException {
		/* nothin for now*/
		return null;
	}

	@Override
	public List<String> listOperations() {
		List<String> lRetVal=new ArrayList<>();
		lRetVal.add("MonthlyPremieRevenue");
		lRetVal.add("YearlyPremie");
		return lRetVal;
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties=pProperties;

	}

}
