package nl.oostnl.ventureplan.jobs.interest;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.ibm.icu.text.SimpleDateFormat;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.Properties;

public class MonthylyPremieRevenueOperation implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(MonthylyPremieRevenueOperation.class);

	private static final String cRunDate = "rundate";
	private static final String cMedewerkerId = "medewerker_id";

	private XamEngine iXE=null;
	private Dataset iDsNota=null;
	private Dataset iDsRc=null;
	private Dataset iDsLening=null;
	private Dataset iDataset;
	private Map<String,Object> iParams;
	private Properties iProperties;
	
	public MonthylyPremieRevenueOperation() throws OperationException {
		iXE=new XamEngine();
		try {
			iDsNota=iXE.getDataset("Nota");
			iDsLening=iXE.getDataset("Lening");
			iDsRc=iXE.getDataset("RC");
		} catch (DatasetException e) {
			throw new OperationException(e);
		}
		iParams=new HashMap<>();
	}

	
	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public void close() {
		/* nothing for now*/

	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		List<Map<String, Object>> lResult=new ArrayList<>();
		
		log4j.info("Properties from ds def: " + iProperties);
		
		if (!iParams.containsKey(cRunDate) || iParams.get(cRunDate)==null){
			SimpleDateFormat lFmt=new SimpleDateFormat("yyyy-MM-dd");
			iParams.put(cRunDate, lFmt.format(new Date()));
			log4j.warn("parameter bookdate not set, defaulting to: " + iParams.get(cRunDate));
		}
		
		
		truncateLog();
		
		processLening(lResult);

		Operation lORenteLog = iDsNota.getOperation("ListRenteLog");
		
		return lORenteLog.executeAsResultset();
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		List<Map<String, Object>> lResultList = new ArrayList<>();
		List<String> lColumnNames = new ArrayList<>();
		
		try {
			ResultSet lResult = this.executeAsResultset();
			ResultSetMetaData lMetaData = lResult.getMetaData();
			int lColumnCount = lMetaData.getColumnCount();
			for(int i = 1; i <= lColumnCount; i++) {
				lColumnNames.add(lMetaData.getColumnName(i));
			}
			
			while(lResult.next()){
				Map<String, Object> lResultRow = new HashMap<>();
				for(String lColumnName : lColumnNames) {
					lResultRow.put(lColumnName, lResult.getObject(lColumnName));
				}
				
				lResultList.add(lResultRow);
			}
		} catch(SQLException e) {
			throw new OperationException(e);
		}
		
		return lResultList;	}


	private void truncateLog() throws OperationException {
		
		Operation iOTruncLog=iDsNota.getOperation("TruncateRenteLog");
		iOTruncLog.executeAsValueMap();
	}


	public void processLening(List<Map<String, Object>> lResult) throws OperationException {
		/* ---process leningen ---*/
		PROCESS_LOGGER.start("Leningen", 1);
		
		//haal leningen op
		Operation lLeningRegels = iDsLening.getOperation("ListOpgebouwdePremie");
		lLeningRegels.setParameter("bookdate", iParams.get(cRunDate));
		Integer lMedewerker = Integer.parseInt((String)iParams.get(cMedewerkerId));
		ResultSet lRentes = lLeningRegels.executeAsResultset();
		
		//per regel maak fin.fact
		try {
			while(lRentes.next()){
				Double lPremie=lRentes.getDouble("PREMIE");
				Integer lFrId = lRentes.getInt("FR_ID");
				String lPremieCode=iProperties.getProperty("LeningPremieCode");
				
				/* als rente ongelijk is aan null maak finfact*/
				if (lPremie != null && lPremie!=0){
					Operation lFinFact=iDsNota.getOperation("CreateFinFact");
					lFinFact.setParameter("code", lPremieCode);
					lFinFact.setParameter("fr_id", lFrId);
					lFinFact.setParameter("waarde", lPremie);
					lFinFact.setParameter("bookdate", iParams.get(cRunDate));
					lFinFact.setParameter("medewerker_id", lMedewerker);
					
					lFinFact.executeAsValueMap();
				}
			}
		} catch (SQLException e) {
			String message="Error processing lening premies";
			log4j.error(message,e);
			throw new OperationException(message, e);
		}
		
		PROCESS_LOGGER.complete("Leningen", 1);
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		return null;
	}

	@Override
	public String getDescription() {
		return "Creates monthly finfacts for interest revenue";
	}

	@Override
	public Operator getOperator(String pArg0) {
		return null;
	}

	@Override
	public void setDataset(Dataset pDS) {
		iDataset = pDS;

	}

	@Override
	public void setParameter(String pKey, Object pValue) throws OperationException {
		iParams.put(pKey, pValue);

	}

	@Override
	public void setParameter(String pArg0, List<Object> pArg1) {
		/* noting for now */
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;
	}

	@Override
	public boolean supportsResultset() {
		return true;
	}

	
}
