package nl.oostnl.ventureplan.jobs.interest;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import com.ibm.icu.text.SimpleDateFormat;

import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.Properties;

public class YearlyPremieOperation implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.1 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(YearlyPremieOperation.class);

	private static final String cRunDate = "rundate";
	private static final String cMedewerkerId = "medewerker_id";

	private XamEngine iXE=null;
	private Dataset iDsNota=null;
	private Dataset iDsLening=null;
	private Dataset iDataset;
	private Map<String,Object> iParams;
	private Properties iProperties;
	
	@Override
	public Operator getOperator(String pName) {
		return null;
	}

	public YearlyPremieOperation() throws OperationException {
		iXE=new XamEngine();
		try {
			iDsNota=iXE.getDataset("Nota");
			iDsLening=iXE.getDataset("Lening");
		} catch (DatasetException e) {
			throw new OperationException(e);
		}
		
		iParams=new HashMap<>();
	}

	@Override
	public void setParameter(String pKey, Object pValue) throws OperationException {
		iParams.put(pKey, pValue);

	}

	@Override
	public void setParameter(String pName, List<Object> pValue) {
		/* noting for now */

	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public boolean supportsResultset() {
		return true;
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		List<Map<String, Object>> lResult=new ArrayList<>();
		log4j.info("Properties from ds def: " + iProperties);
		
		if (!iParams.containsKey(cRunDate) || iParams.get(cRunDate)==null){
			SimpleDateFormat lFmt=new SimpleDateFormat("yyyy-MM-dd");
			iParams.put(cRunDate, lFmt.format(new Date()));
			log4j.warn("parameter bookdate not set, defaulting to: " + iParams.get(cRunDate));
		}
		
		
		truncateLog();
		
		processRC(lResult);
		
		Operation lORenteLog = iDsNota.getOperation("ListRenteLog");
		
		return lORenteLog.executeAsResultset();	}

	private void processRC(List<Map<String, Object>> pResult) throws OperationException {
		/* ---process RC ---*/
		PROCESS_LOGGER.start("Lening", 1);
		
		//haal rc op
		Operation lRCRegels = iDsLening.getOperation("ListYearlyOpgebouwdePremie");
		lRCRegels.setParameter("bookdate", iParams.get(cRunDate));
		Integer lMedewerker = Integer.parseInt((String)iParams.get(cMedewerkerId));
		ResultSet lRCRentes = lRCRegels.executeAsResultset();
		
		//per regel maak fin.fact
		try {
			while(lRCRentes.next()){
				Double lRente=null;
				Integer lFrId = lRCRentes.getInt("FR_ID");
				
				String lRenteCode=null;
				String lBRenteCode=null;
				
				lRenteCode=iProperties.getProperty("LeningYearPremieCode");
				lRente=lRCRentes.getDouble("RENTE_DEBET");
				
				/* als rente ongelijk is aan null maak finfact*/
				if (lRente != null && lRente!=0){
					Operation lFinFact=iDsNota.getOperation("CreateFinFactStartOfYear");
					lFinFact.setParameter("code", lRenteCode);
					lFinFact.setParameter("fr_id", lFrId);
					lFinFact.setParameter("waarde", lRente);
					lFinFact.setParameter("bookdate", iParams.get(cRunDate));
					lFinFact.setParameter("medewerker_id", lMedewerker);
					
					lFinFact.executeAsValueMap();
				}
			}
		} catch (SQLException e) {
			String message="Error processing premies";
			log4j.error(message,e);
			throw new OperationException(message, e);
		}
		
		PROCESS_LOGGER.complete("Lening", 1);	}

	private void truncateLog()  throws OperationException  {
		Operation iOTruncLog=iDsNota.getOperation("TruncateRenteLog");
		iOTruncLog.executeAsValueMap();
		
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		List<Map<String, Object>> lResultList = new ArrayList<>();
		List<String> lColumnNames = new ArrayList<>();
		
		try {
			ResultSet lResult = this.executeAsResultset();
			ResultSetMetaData lMetaData = lResult.getMetaData();
			int lColumnCount = lMetaData.getColumnCount();
			for(int i = 1; i <= lColumnCount; i++) {
				lColumnNames.add(lMetaData.getColumnName(i));
			}
			
			while(lResult.next()){
				Map<String, Object> lResultRow = new HashMap<>();
				for(String lColumnName : lColumnNames) {
					lResultRow.put(lColumnName, lResult.getObject(lColumnName));
				}
				
				lResultList.add(lResultRow);
			}
		} catch(SQLException e) {
			throw new OperationException(e);
		}
		
		return lResultList;	}

	@Override
	public void close() {
		/* nothing for now*/
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;

	}

	@Override
	public void setDataset(Dataset pDS) {
		iDataset = pDS;
	}

	@Override
	public String getDescription() {
		return "Creates the yearly interest fin.facts";
	}

}
