package nl.oostnl.ventureplan.jobs.organisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import net.sf.json.JSONObject;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Properties;

public class AddOrganisationOperation implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.6 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private Map<String, Object> iParams;
	private Dataset iDataset;
	private Properties iProperties;
	private static final String corgdyn = "orgDyn";

	public AddOrganisationOperation() {
		iParams = new HashMap<>();
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public void close() {
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		// TODO DeviceInfo in list teruggeven

		// create url object
		//String token = iProperties.getProperty("Key");
		String token = ConfigurationProperties.get().get("Dynamics.Key");
		String url_string = ConfigurationProperties.get().get("Dynamics.Addurl");
		
		if (log4j.isDebugEnabled()){
			log4j.debug("Dynamics.key = " + token);
			log4j.debug("Dynamics.Addurl = " + url_string);
		}
		
		

		String org_dynamics = iParams.get(corgdyn).toString();

		URL url = null;
		try {
			url = new URL(url_string);
		} catch (MalformedURLException e) {
			log4j.error("Invallid Addurl",e);
			throw new OperationException("Invallid Addurl",e);
		}
		// open the connection
		HttpURLConnection con = null;
		try {
			con = (HttpURLConnection) url.openConnection();

		} catch (IOException e1) {
			log4j.error("Could not open url: " + url,e1);
			throw new OperationException("Could not open url: " + url,e1);
		}
		// set request method to POST
		try {
			con.setRequestMethod("POST");
		} catch (ProtocolException e) {
			log4j.error("Error during POST",e);
			throw new OperationException("Error during POST",e);
		}
		// get response from in the desired format
		con.setRequestProperty("Content-Type", "application/json");
		con.setRequestProperty("Accept", "application/json");

		// send token with request
		con.setRequestProperty("Authorization", "Bearer " + token);

		// ensure connection will be used to send content
		con.setDoOutput(true);
		// create and write JSON Object
		JSONObject jo = new JSONObject();
		jo.put("DynamicsId", org_dynamics);
		// System.out.println(jo.toString());
		try (OutputStream os = con.getOutputStream()) {
			byte[] input = jo.toString().getBytes("utf-8");
			os.write(input, 0, input.length);
		} catch (IOException e) {
			log4j.error("Error fetching data",e);
			throw new OperationException("Error fetching data",e);
		}

		// read the response from input stream
		List<Map<String, Object>> service_answer2 = null;
		JSONObject service_answer = null;
		try {
			InputStreamReader service_stream = new InputStreamReader(con.getInputStream());
			BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
			StringBuilder sb = new StringBuilder();
			String line;
			while ((line = br.readLine()) != null) {
				sb.append(line + "\n");
			}
			br.close();

			// remove brackets for good JSON format
			service_answer = JSONObject.fromObject((sb.toString()));
			// service_answer2.add(sb.toString());
			String jsonstring = service_stream.toString();
		} catch (IOException e) {
			log4j.error("Error processing data",e);
			throw new OperationException("Error processing data",e);
		}
		List<Map<String, Object>> list = new ArrayList<>();
		Iterator it = service_answer.keySet().iterator();

		// convert each line in the JSONObject to Map<String, Object> and set
		// map to List
		Map map = new HashMap();

		while (it.hasNext()) {
			String question = (String) it.next();
			// System.out.println(question);
			Object question_answer = service_answer.get(question);
			// System.out.println(question_answer);
			List<Object> objectlist = new ArrayList<Object>();
			objectlist.add(question_answer);
			// System.out.println(objectlist);
			// System.out.println(objectlist.toString());
			map.put(question, objectlist);
			// System.out.println(map);
			list.add(map);
		}
		return map;
	}

	@Override
	public String getDescription() {
		return "Get info from specific device";
	}

	@Override
	public Operator getOperator(String arg0) {
		return null;
	}

	@Override
	public void setDataset(Dataset pDS) {
		iDataset = pDS;

	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);
	}

	@Override
	public void setParameter(String arg0, List<Object> arg1) {
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;
	}

	@Override
	public boolean supportsResultset() {
		return false;
	}

}
