package nl.oostnl.ventureplan.jobs.organisation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.knowledgeplaza.util.ConfigurationProperties;
import nl.knowledgeplaza.util.Properties;

public class SearchOrganisationOperation implements Operation {
	/** Standard variable for determining version of a class file. */
	public static final String SOURCECODE_VERSION = "$Revision: 1.10 $";

	/** set up a Log4J category to log in */
	private static Logger log4j = nl.knowledgeplaza.util.Log4jUtil.createLogger();

	private Map<String, Object> iParams;
	private Dataset iDataset;
	private Properties iProperties;
	private static final String corgname = "orgname";
	private static final String corgkvk = "orgkvk";
	private static final String corgcity = "orgcity";

	public SearchOrganisationOperation() {
		iParams = new HashMap<>();
	}

	@Override
	public boolean canExecute() {
		return true;
	}

	@Override
	public void close() {
	}

	@Override
	public ResultSet executeAsResultset() throws OperationException {
		return null;
	}

	@Override
	public List<Map<String, Object>> executeAsValueList() throws OperationException {
		// TODO DeviceInfo in list teruggeven

		return null;
	}

	@Override
	public Map<String, List<Object>> executeAsValueMap() throws OperationException {
		// create url object
//		String token = iProperties.getProperty("Key");
//		String url_string = iProperties.getProperty("Searchurl");
		
		String token = ConfigurationProperties.get().get("Dynamics.Key").toString();
		

		String url_string = ConfigurationProperties.get().get("Dynamics.Searchurl").toString();
		
		if (log4j.isDebugEnabled()){
			log4j.debug("Dynamics.key = " + token);
			log4j.debug("Dynamics.Addurl = " + url_string);
		}
		
		String org_name = iParams.get(corgname).toString();
		String kvk_id = iParams.get(corgkvk).toString();
		String org_city = iParams.get(corgcity).toString();
		
		
		
		URL url = null;
		try {
			url = new URL(url_string);
		} catch (MalformedURLException e) {
			log4j.error("Invallid Searchurl",e);
			throw new OperationException("Invallid Searchurl",e);
		}
		// open the connection
		HttpURLConnection con = null;
		try {
			con = (HttpURLConnection) url.openConnection();
		} catch (IOException e1) {
			log4j.error("Could not open url: " + url,e1);
			throw new OperationException("Could not open url: " + url,e1);
		}
		// set request method to POST
		try {
			con.setRequestMethod("POST");
		} catch (ProtocolException e) {
			log4j.error("Error during POST",e);
			throw new OperationException("Error during POST",e);
		}
		// set content_type to application/json
		con.setRequestProperty("Content-Type", "application/json");
		// get response from in the desired format
		con.setRequestProperty("Accept", "application/json");
		// send token with request
		con.setRequestProperty("Authorization", "Bearer " + token);

		// ensure connection will be used to send content
		con.setDoOutput(true);
		// create and write JSON Object
		JSONObject jo = new JSONObject();
		jo.put("Name", org_name);
		jo.put("KvK", kvk_id);
		jo.put("City", org_city);
		try (OutputStream os = con.getOutputStream()) {
			byte[] input = jo.toString().getBytes("utf-8");
			os.write(input, 0, input.length);
		} catch (IOException e) {
			log4j.error("Error fetching data",e);
			throw new OperationException("Error fetching data",e);
		}
		// read the response from input stream
		List<Map<String, Object>> service_answer2 = null;
		JSONObject service_answer = null;
		JSONArray service_answer_array = null;
		Map map = new HashMap();
		try {
			InputStreamReader service_stream = new InputStreamReader(con.getInputStream());
			BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
			String objectfromapi = br.readLine();
			if(log4j.isDebugEnabled()){
				log4j.debug("JSON returned from service: " + objectfromapi);
			}
			try {
				// remove brackets for good JSON format
				service_answer_array = JSONArray.fromObject(objectfromapi);
			} catch (JSONException e){
				log4j.error("Could not parse JSON from service",e);
				throw new OperationException("Could not parse JSON from service",e);
			}
			// service_answer = JSONObject.fromObject(objectfromapi);
			for (int i = 0; i < service_answer_array.size(); i++) {
//				System.out.println("json object test:" + service_answer_array.getJSONObject(i).toString());

				// service_answer2.add(sb.toString());
				// System.out.println(sb.toString());
				// System.out.println(con.getInputStream());
				String jsonstring = service_stream.toString();

				Iterator it = service_answer_array.getJSONObject(i).keySet().iterator();

				// convert each line in the JSONObject to Map<String,
				// Object>
				// and set
				// map to List

				;

				while (it.hasNext()) {
					String key = it.next().toString();
					Object object = service_answer_array.getJSONObject(i);
					String value = service_answer_array.getJSONObject(i).get(key).toString();
					if (value == "null"){
						value = "";
					}
//					System.out.println("key: " + key);
//					System.out.println("value: " + value);
					ArrayList<Object> list;
					if (map.containsKey(key)) {
						list = (ArrayList<Object>) map.get(key);
						list.add(value);
					} else {
						list = new ArrayList<Object>();
						list.add(value);
						map.put(key, list);
					}

				}
			}

		} catch (IOException e) {
			log4j.error("Error processing data",e);
			throw new OperationException("Error processing data",e);
		}
		return map;
	}

	@Override
	public String getDescription() {
		return "Get info from specific device";
	}

	@Override
	public Operator getOperator(String arg0) {
		return null;
	}

	@Override
	public void setDataset(Dataset pDS) {
		iDataset = pDS;

	}

	@Override
	public void setParameter(String pName, Object pValue) throws OperationException {
		iParams.put(pName, pValue);
	}

	@Override
	public void setParameter(String arg0, List<Object> arg1) {
	}

	@Override
	public void setProperties(Properties pProperties) {
		iProperties = pProperties;
	}

	@Override
	public boolean supportsResultset() {
		return false;
	}
}
