/*
 * Decompiled with CFR 0.152.
 */
package nl.oostnl.ventureplan.jobs.clockwise;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import nl.buildersenperformers.xam.engine.Dataset;
import nl.buildersenperformers.xam.engine.DatasetException;
import nl.buildersenperformers.xam.engine.Operation;
import nl.buildersenperformers.xam.engine.OperationException;
import nl.buildersenperformers.xam.engine.Operator;
import nl.buildersenperformers.xam.engine.XamEngine;
import nl.buildersenperformers.xam.engine.logging.ProcessLogManager;
import nl.buildersenperformers.xam.engine.logging.ProcessLogger;
import nl.knowledgeplaza.util.Log4jUtil;
import nl.knowledgeplaza.util.Properties;
import nl.ppmoost.ventureplan2.ClockWiseException;
import nl.ppmoost.ventureplan2.ClockWiseREST;
import org.apache.log4j.Logger;
import org.postgresql.util.PGobject;

public class ImportFromClockwise
implements Operation {
    public static final String SOURCECODE_VERSION = "$Revision: 1.2 $";
    private static Logger log4j = Log4jUtil.createLogger();
    private static ProcessLogger PROCESS_LOGGER = ProcessLogManager.getLogger(ImportFromClockwise.class);
    private Properties iProperties;
    private Map<String, Object> iParams;
    private XamEngine iXE = new XamEngine();
    private Dataset iDataset;
    private Dataset iUren;

    public ImportFromClockwise() {
        try {
            this.iUren = this.iXE.getDataset("Uren");
        }
        catch (DatasetException e) {
            throw new RuntimeException(e);
        }
    }

    public Operator getOperator(String pName) {
        return null;
    }

    public void setParameter(String pName, Object pValue) throws OperationException {
        this.iParams.put(pName, pValue);
    }

    public void setParameter(String pName, List<Object> pValue) {
    }

    public boolean canExecute() {
        return true;
    }

    public boolean supportsResultset() {
        return false;
    }

    public ResultSet executeAsResultset() throws OperationException {
        return null;
    }

    public Map<String, List<Object>> executeAsValueMap() throws OperationException {
        return null;
    }

    public List<Map<String, Object>> executeAsValueList() throws OperationException {
        String lClientId = this.iProperties.getProperty("ClientId");
        String lUsername = this.iProperties.getProperty("Username");
        String lPassword = this.iProperties.getProperty("Password");
        String lUrenEndpoint = this.iProperties.getProperty("lUrenEndpoint");
        String lContentStr = null;
        try {
            ClockWiseREST lCWRest = new ClockWiseREST();
            lCWRest.getAccessToken(lClientId, lUsername, lPassword);
            lContentStr = lCWRest.doGetString(lUrenEndpoint);
        }
        catch (ClockWiseException e) {
            throw new OperationException((Throwable)e);
        }
        Operation lOperTruncate = this.iUren.getOperation("TruncateTemp");
        lOperTruncate.executeAsValueMap();
        lOperTruncate.close();
        Operation lOperImport = this.iUren.getOperation("Import");
        try {
            PGobject lJsonObject = new PGobject();
            lJsonObject.setType("json");
            lJsonObject.setValue(lContentStr);
            lOperImport.setParameter("content", (Object)lJsonObject);
            lOperImport.executeAsValueMap();
        }
        catch (SQLException e) {
            throw new OperationException((Throwable)e);
        }
        Operation lOperProcess = this.iUren.getOperation("Process");
        return lOperProcess.executeAsValueList();
    }

    public void close() {
    }

    public void setProperties(Properties pProperties) {
        this.iProperties = pProperties;
    }

    public void setDataset(Dataset pDataset) {
        this.iDataset = pDataset;
    }

    public String getDescription() {
        return "Import uren samenvatting van Clockwise in Ventureplan";
    }
}

